<?php
/**
 * @link         http://www.openzc.cn/
 * @author       hexipeng | e-mail:2017412656@qq.com
 * @copyright    Copyright (c) 2020, Openzc, Inc.
 * @license      http://www.openzc.cn/license.txt
 */
//商品筛选过滤导航类库
class filter{
    
	//获取已选导航
	function get_active_bar($GET){
		global $predata_class,$currencies;
		$symbol=$currencies->currencies[$_SESSION['currency']]['symbol_left'];
		$row=0;
		
		foreach($GET as $k => $v){
			switch($k){
				case "brand":
					$rs[$row]['item_id']=$row;
					$rs[$row]['filter_item']=$k;
					$manufacturers=$predata_class->getPredata(TABLE_MANUFACTURERS);
					$parameter=$this->get_page_parameter($GET,"brand");
					$array=array_filter(explode(",",$GET['brand']));
					foreach($array as $a => $b){
						$brand=$array;
						unset($brand[$a]);
						$brand_ids=join(",",$brand);
						$bar['filter_name']=$manufacturers[$b]['manufacturers_name'];
						if($brand_ids){$bar['filter_link']=zen_href_link($GET['main_page'],$parameter."&brand=".$brand_ids);}
						else{$bar['filter_link']=zen_href_link($GET['main_page'],$parameter);}
						$bar['filter_id']=$row."_".$a;
						$rs[$row]['values'][]=$bar;
					}
					$row++;
				break;
				case "price":
					$categories=$predata_class->getPredata(TABLE_CATEGORIES);
					$rs[$row]['item_id']=$row;
					$rs[$row]['filter_item']=$k;
					$parameter=$this->get_page_parameter($GET,"price");
					$array=array_filter(explode("|",$GET['price']));
					
					//$array=$this->price_exchange_rate($array);
					$space=explode(",",$array[0]);
					$space=$space[1]-$space[0];
				
					switch($_GET['main_page']){
						case FILENAME_SPECIALS:
							$maxsql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_SPECIALS." s left join ".TABLE_PRODUCTS." p on s.products_id=p.products_id left join ".TABLE_PRODUCTS_DESCRIPTION." pd on pd.products_id=s.products_id where s.status='1' and pd.language_id='".(int)$_SESSION['languages_id']."'";
						break;
						case FILENAME_PRODUCTS_ALL:
							$maxsql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_PRODUCTS." p left join ".TABLE_PRODUCTS_DESCRIPTION." pd on pd.products_id=p.products_id where pd.language_id='".(int)$_SESSION['languages_id']."'";
						break;
						case FILENAME_FEATURED_PRODUCTS:
							$maxsql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_FEATURED." f left join ".TABLE_PRODUCTS." p on f.products_id=p.products_id left join ".TABLE_PRODUCTS_DESCRIPTION." pd on pd.products_id=f.products_id where f.status='1' and pd.language_id='".(int)$_SESSION['languages_id']."'";
						break;
					}
					if(!empty($maxsql)){
						$max=openzcQuery($maxsql);
						$data=$this->get_price_section($max->fields['min'],$max->fields['max'],$space,false);
					}else{
						$data=$this->get_price_section($categories[$GLOBALS['currentCid']]['min'],$categories[$GLOBALS['currentCid']]['max'],$space,false);
					}
					foreach($array as $a => $b){
						$price=$array;
						unset($price[$a]);
						$price_ids=openzc_get_each_ids($price,'',"|");
						$b=explode(",",$b);
						foreach($data as $c => $d){
							if($b[0]>=$d['min'] && $b[1]<=$d['max']){
								$bar['filter_name']=$d['filter_name'];
							}
						}
						if($price_ids){$bar['filter_link']=zen_href_link($GET['main_page'],$parameter."&price=".$price_ids);}
						else{$bar['filter_link']=zen_href_link($GET['main_page'],$parameter);}
						$bar['filter_id']=$row."_".$a;
						$rs[$row]['values'][]=$bar;
					}
					$row++;
				break;
				case "options":
					$data=[];
					$options=$predata_class->getPredata(TABLE_PRODUCTS_OPTIONS);
					$options_values=$predata_class->getPredata(TABLE_PRODUCTS_OPTIONS_VALUES);
					
					$parameter=$this->get_page_parameter($GET,"options");
					$array=array_filter(explode("|",$GET['options']));

					$options_array=[];
					foreach($array as $a => $b){
						$b=array_filter(explode(":",$b));
						$values=array_filter(explode(",",$b[1]));
						$options_array[$b[0]]=$values;
						/*
						$options_id=$b[0];
						
						$values=array_filter(explode(",",$b[1]));
						foreach($values as $c => $d){
							$bar['filter_name']=$options_values[$d]['products_options_values_name'];
							$bar['filter_link']="";
							$data[$options_id][]=$bar;
						}
						
						$bar['filter_name']=$options_values[$b]['products_options_values_name'];
						if($options_ids){$bar['filter_link']=zen_href_link($GET['main_page'],$parameter."&options=".$options_ids);}
						else{$bar['filter_link']=zen_href_link($GET['main_page'],$parameter);}
						$data[$options_id][]=$bar;*/
					}
					//print_r($options_array);exit;
					foreach($options_array as $a => $b){
						
						foreach($b as $c => $d){
							$options_str=$options_array;
							unset($options_str[$a][$c]);
							$string=[];
							foreach($options_str as $x => $y){
								if(count($y)>0){
									$string[]=$x.":".join(",",$y);
								}
							}
							
							$bar['filter_name']=$options_values[$d]['products_options_values_name'];
							if(count($string)>0){
								$string=join("|",$string);
								$bar['filter_link']=zen_href_link($GET['main_page'],$parameter."&options=".$string);
							}else{
								$bar['filter_link']=zen_href_link($GET['main_page'],$parameter);
							}
							
							
							
							$data[$a][]=$bar;
						}
					}

					foreach($data as $a => $b){
						$rs[$row]['item_id']=$row;
						$rs[$row]['filter_item']=$options[$a]['products_options_name'];
						foreach($b as $c => $d){
							$d['filter_id']=$row."_".$c;
							$rs[$row]['values'][]=$d;
						}
						$row++;
					}

					
				break;
			}
		}
		$clear=$this->get_filter_clear();
		$clear[0]['filter_item']="clear";
		$rs[]=$clear[0];
		
		return $rs;
	}
	function get_filter_clear(){
		$main_page=$_GET['main_page'];
		foreach($_GET as $k => $v){
			if($k!="brand" && $k!="price" && $k!="options" && $k!="main_page" && $k!="sort"){
				$str.="&".$k."=".$v;
			}else{
				$n++;
			}
		}
		if($n>1){
			$filter[0]['filter_id']="0";
			$filter[0]['filter_name']="Clear Filter";
			$filter[0]['filter_link']=zen_href_link($main_page,$str);
		}else{
			$filter=array();
		}
		return $filter;
	}
	//查询语句预处理
	function get_prepare_sql($name="",$sql="",$varlist=[],$index_field=""){
		$sqllist=[];
		$using=[];
		foreach($varlist as $k => $v){
			$sql=str_replace("$".($k+1),$v,$sql);
		}
		$sqllist[]="PREPARE ".$name." from ".'"'.$sql.'"';
		foreach($varlist as $k => $v){
			$sqllist[]="set @var".($k+1)."='".$v."'";
			$using[]="@var".($k+1);
		}
		$sqllist[]="EXECUTE ".$name." USING ".join(",",$using);
		$sqllist[]="DEALLOCATE PREPARE ".$name;
		//print_r($sqllist);exit;
		foreach($sqllist as $k => $v){
			if(strstr($v,"EXECUTE")){
				$data=openzcQuery($v);
				$data=openzc_table_to_list($data,$index_field);

			}else{
				openzcQuery($v);
			}
		}

		return $data;
	}
	//根据品牌筛选商品
	function get_brand_bar($GET,$mul){
		global $predata_class;
		$manufacturers=$predata_class->getPredata(TABLE_MANUFACTURERS);
		
		$parameter=$this->get_page_parameter($GET,"brand");
		$sqldata=$this->get_filter_sql("brand",$GET);

		$data=$this->get_prepare_sql("filter_brand",$sqldata['sql'],$sqldata['varlist'],"manufacturers_id");
		//print_r($data);exit;
		$data=$this->get_default_data("brand",$data);
		
		$filtered=array_filter(explode(",",$GET['brand']));
		$filtered=openzc_field_to_key($filtered);
		
		if(count($data)>0){
			foreach($manufacturers as $k => $v){
				if(isset($data[$k])){
					$filtereds=$filtered;
					if(isset($filtereds[$k])){
						$rs[$k]['status']="active";
						unset($filtereds[$k]);
					}else{
						$rs[$k]['status']="";
						$filtereds[$k]=$k;
					}
	
					$rs[$k]['filter_id']="b_".$k;
					$rs[$k]['filter_count']=$data[$k]['filter_count'];
					$rs[$k]['filter_name']=$v['manufacturers_name'];
					$rs[$k]['filter_image']=$v['manufacturers_image'];
					if($data[$k]['filter_count']>0){
						if($mul!='true' && !isset($filtered[$k]) && is_array($filtered)){
							$rs[$k]['filter_link']=zen_href_link($GET['main_page'],$parameter."&brand=".$k);
						}else{
							if(count($filtereds)>0){
								$rs[$k]['filter_link']=zen_href_link($GET['main_page'],$parameter."&brand=".join(",",$filtereds));
							}else{
								$rs[$k]['filter_link']=zen_href_link($GET['main_page'],$parameter);
							}
						}
					}else{
						$rs[$k]['filter_link']="javascript:void(0);";
					}
				}
			}
			
			return $rs;
		}
		
		return false;
		
		
	}
	
	//根据商品价格筛选
	function get_price_bar($GET,$space='',$mul=true,$slide=''){
		global $predata_class,$currencies;
		
		$parameter=$this->get_page_parameter($GET,"price");
		$categories=$predata_class->getPredata(TABLE_CATEGORIES);
		if(isset($GET['cPath'])){
			$cid=openzc_get_current_cpath($GET['cPath']);
			if($categories[$cid]['categories_sub_all_id']!="none"){
				$cid=$categories[$cid]['categories_sub_all_id'];
			}
			$cids=array_filter(explode(",",str_replace("none","",$cid)));
			$var=[];
			foreach($cids as $k => $v){
				$varlist[]=$v;
				$var[]="?";
			}
			
			//$cid_where="p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in(".join(",",$var).")) and";
			$cid_where="p.master_categories_id in(".join(",",$var).") and";
		}
		
		$varlist[]=$_SESSION['languages_id'];
		switch($_GET['main_page']){
			case FILENAME_SPECIALS:
				$sql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id where pd.language_id=? and p.products_id in(select products_id from ".TABLE_SPECIALS." where status=1) and p.products_status='1'";
			break;
			case FILENAME_FEATURED_PRODUCTS:
				$sql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id where pd.language_id=? and p.products_id in(select products_id from ".TABLE_FEATURED." where status=1) and p.products_status='1'";
			break;
			case FILENAME_ADVANCED_SEARCH_RESULT:
				if(isset($GET['cPath'])){if($GET['cPath']==0){unset($GET['cPath']);}}
				if(isset($GET['cPath'])){
					$sql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id where p.products_status='1' and ".$cid_where." pd.products_name like '%".$GET['keyword']."%' and pd.language_id=?";
				}else{
					$sql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id where pd.products_name like '%".$GET['keyword']."%' and p.products_status='1' and pd.language_id=?";
				}
			break;
			case FILENAME_ADVANCED_SEARCH:
				if(isset($GET['cPath'])){if($GET['cPath']==0){unset($GET['cPath']);}}
				if(isset($GET['cPath'])){
					$sql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id where p.products_status='1' and ".$cid_where." pd.products_name like '%".$GET['keyword']."%' and pd.language_id='".(int)$_SESSION['languages_id']."'";
				}else{
					$sql="select max(p.products_price_sorter) as max,min(p.products_price_sorter) as min from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id where pd.products_name like '%".$GET['keyword']."%' and p.products_status='1' and pd.language_id=?";
				}
			break;
			
		}
		$range=[];
		if($sql){

		}else{
			if(isset($_GET['cPath']) && $GET['cPath']){
				$range=$categories[openzc_get_current_cpath($GET['cPath'])];
			}
		}
		if($space=="getrange"){return ['min'=>$range['min'],'max'=>$range['max']];}
		$max=$range['max'];
		$min=$range['min'];
		
		$data=$this->get_price_section($min,$max,$space,$slide);
		
		if($slide==true){
			
			$rate=$currencies->currencies[$_SESSION['currency']]['value'];
			foreach($data as $k => $v){
				$v['min']=floor($min*$rate);
				$v['max']=ceil($max*$rate);
				if(isset($_GET['price'])){
					$price=explode(",",$_GET['price']);
					$v['slide_min']=floor($price[0]*$rate);
					$v['slide_max']=ceil($price[1]*$rate);
				}else{
					$v['slide_min']=$v['min'];
					$v['slide_max']=$v['max'];
				}
				
				$v['filter_link']=zen_href_link($GET['main_page'],$parameter);
				$rs[]=$v;
			}
			return $rs;
		}
		
		//$price_group_count_sql="select ";
		//foreach($data as $k => $v){
		//	$price_group_count_sql.="sum(case when price"
		//}
		//$sql="select sum(case when products_price_sorter between 90 and 100 then 1 else 0 end ) as 优秀,
		//sum(case when examination_score between 80 and 90 then 1 else 0 end ) as 良好 from el_test_info";
		
		$price_group_sql_array=[];
		foreach($data as $k => $v){
			if($k==(count($data)-1)){
				$price_group_sql_array[]="sum(case when p.products_price_sorter>=".$v['min']." and p.products_price_sorter<=".$v['max']." then 1 else 0 end ) as price_group_".$k;
			}else{
				$price_group_sql_array[]="sum(case when p.products_price_sorter>=".$v['min']." and p.products_price_sorter<".$v['max']." then 1 else 0 end ) as price_group_".$k;
			}
			
		}
		if($categories[openzc_get_current_cpath($GET['cPath'])]['categories_sub_all_id']=="none"){
			$current_son_ids=openzc_get_current_cpath($GET['cPath']);
		}else{
			$current_son_ids=$categories[openzc_get_current_cpath($GET['cPath'])]['categories_sub_all_id'];
		}
		
		$price_group_sql="select ".join(",",$price_group_sql_array)." from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id where p.master_categories_id in(".$current_son_ids.") and pd.language_id=".$_SESSION['languages_id'];

		$default_group_data=openzcQuery($price_group_sql);
		$default_group_data=openzc_table_to_list($default_group_data);

		$total=$default_group_data[0];

		foreach($data as $k => $v){
			if($total['price_group_'.$k]>0){
				$data[$k]['filter_count']=$total['price_group_'.$k];
				$data[$k]['filter_count_total']=$total['price_group_'.$k];
			}else{
				unset($data[$k]);
			}
		}

		//价格分组+条件筛选
		$group_price_filter_count_sql=$this->get_filter_sql("price",$GET,$data,$mul);
		//echo $group_price_filter_count_sql['sql'];exit;
		$group_price_filter_count=$this->get_prepare_sql("filter_price_group",$group_price_filter_count_sql['sql'],$group_price_filter_count_sql['varlist']);
		$group_price_filter_count=$group_price_filter_count[0];
		/**价格分组并条件筛选
		foreach($data as $k => $v){
			if($k==$end){$type="end";}
			if($total['price_group_'.$k]>0){
				$sql=$this->get_filter_sql("price",$GET,[$v['min'],$v['max'],$type],$mul);
				$count=$this->get_prepare_sql("filter_price_count",$sql['sql'],$sql['varlist']);
				$data[$k]['filter_count']=$count[0]['filter_count'];
			}else{
				unset($data[$k]);
			}
		}
		**/
		foreach($data as $k => $v){

			if(array_key_exists("price",$GET)){
				$price=explode("|",$GET['price']);
				$price=array_filter($price);
			}else{
				$price=array();
			}
			if(isset($group_price_filter_count['price_group_'.$k])){
				$v['filter_count']=$group_price_filter_count['price_group_'.$k];
			}else{
				$v['filter_count']=0;
			}
			if($v['filter_count']>0){
				$limits=$v['min'].",".$v['max'];
				if(strstr("#".$GET['price']."#","#".$limits."#") && array_key_exists("price",$GET)){
					$v['status']='active';
					foreach($price as $a => $b){
						if($b==$limits)unset($price[$a]);
					}
					if(count($price)==0){
						$v['filter_link']=zen_href_link($GET['main_page'],$parameter);
					}else{
						$v['filter_link']=zen_href_link($GET['main_page'],$parameter."&price=".join("|",$price));
					}
				}else{
					$v['status']='';
					if($mul==true && count($price)>0){
						$price[]=$limits;
						$v['filter_link']=zen_href_link($GET['main_page'],$parameter."&price=".join("|",$price));
					}else{
						$v['filter_link']=zen_href_link($GET['main_page'],$parameter."&price=".$limits);
					}
				}
			
				$rs[]=$v;
			}else{
				$v['filter_link']="javascript:void(0)";
				$rs[]=$v;
			}
		}
		if(isset($_GET['price']) && isset($_COOKIE['slideprice'])){
			$price=explode(",",$_GET['price']);
			$slideprice=json_decode($_COOKIE['slideprice'],true);
			$slideprice['slide_min']=$price[0];
			$slideprice['slide_max']=$price[1];
			set_cookie("slideprice",json_encode($slideprice));
		}
		
		return $rs;
	}
	
	//根据商品属性筛选
	function get_attr_bar($GET=[],$options_id='',$mul=false,$no_options_id="",$flag="",$no_flag=""){

		global $predata_class;
		$options=$predata_class->getPredata(TABLE_PRODUCTS_OPTIONS);
		$options_values=$predata_class->getPredata(TABLE_PRODUCTS_OPTIONS_VALUES);

		$type=["select"=>"0","text"=>"1","radio"=>"2","checkbox"=>"3","file"=>"4","read"=>"5"];
		if($no_flag){
			$no_flag=explode(",",$no_flag);
			foreach($no_flag as $k => $v){$noflag[$type[$v]]=$type[$v];}
		}
		if($flag){
			$flagstr=explode(",",$flag);
			foreach($flagstr as $k => $v){$flags[$type[$v]]=$type[$v];}
		}
		if($options_id && $options_id!="all"){
			$options_id=explode(",",$options_id);
			$options_id=openzc_field_to_key($options_id);
		}else if($flags && $flag!="all"){
			$options_id=[];
			foreach($options as $k => $v){
				if(!isset($no_options_id[$v['products_options_id']]) && !isset($noflag[$v['products_options_type']]) && isset($flags[$v['products_options_type']])){
					$options_id[$v['products_options_id']]=$v['products_options_id'];
				}
			}
		}else{
			if($options_id=="all" || $flag=="all"){
				$options_id=[];
				$no_options_id=explode(",",$no_options_id);
				$no_options_id=openzc_field_to_key($no_options_id);
				foreach($options as $k => $v){
					if(!isset($no_options_id[$v['products_options_id']]) && !isset($noflag[$v['products_options_type']])){
						$options_id[$v['products_options_id']]=$v['products_options_id'];
					}
				}
			}else{
				$options_id=array();
			}
		}
		
		$parameter=$this->get_page_parameter($GET,"options");
		
		$cid=openzc_get_current_cpath($GET['cPath']);
		$varlist=[];
		switch($_GET['main_page']){
			case FILENAME_SPECIALS:
				$varlist[]=$_SESSION['languages_id'];
				$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_SPECIALS." where status=1) and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 group by pa.options_id";
			break;
			case FILENAME_FEATURED_PRODUCTS:
				$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_FEATURED." where status=1) and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 group by pa.options_id";
			break;
			case FILENAME_ADVANCED_SEARCH_RESULT:
				if(isset($_GET['keyword'])){
					if(isset($_GET['cPath'])){
						$categories=$predata_class->getPredata(TABLE_CATEGORIES);
						$cids=$categories[$cid]['categories_sub_all_id'];
						if($cids=="none"){$cids=$cid;}
						
						//$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."' and products_name like '%".$_GET['keyword']."%') and p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in(".join(",",$var).")) and p.products_status=1 group by pa.options_id";
						$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."' and products_name like '%".$_GET['keyword']."%') and p.master_categories_id in(".$cids.") and p.products_status=1 group by pa.options_id";
					}else{
						$varlist[]=$_SESSION['languages_id'];
						$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=? and p.products_status=1 and products_name like '%".$_GET['keyword']."%') and p.products_status=1 group by pa.options_id";
					}
				}
			break;
			case FILENAME_PRODUCTS_ALL:
				$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=?) and p.products_status=1 group by pa.options_id";
			break;
			default:
				if(isset($_GET['cPath'])){
					$categories=$predata_class->getPredata(TABLE_CATEGORIES);
					$cids=$categories[$cid]['categories_sub_all_id'];
					if($cids=="none"){$cids=$cid;}
					//$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in(".join(",",$var).")) and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 group by pa.options_id";
					$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.master_categories_id in(".$cids.") and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 group by pa.options_id";

				}else{
					$sql="select pa.options_id from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 group by pa.options_id";
				}
				
			break;
		}
		$options_ids=openzcQuery($sql);
		$options_ids=openzc_table_to_list($options_ids,"options_id");
		
		$data=array();
		$result=array();
		
		$modules_options=TPL_MODULES."json/options.json";
		if(is_file($modules_options)){
			$modules_options=json_decode(file_get_contents($modules_options),true);
		}else{
			$modules_options=array();
		}

		//已选属性
		$filtered_options=[];
		if(isset($GET['options']) && $GET['options']){
			$filtered=array_filter(explode("|",$GET['options']));
			foreach($filtered as $k => $v){
				$array=array_filter(explode(":",$v));
				$filtered_options[$array[0]]=openzc_field_to_key(array_filter(explode(",",$array[1])));
			}
		}

		foreach($options_ids as $k => $v){
			if(count($options_id)>0){
				if(!isset($options_id[$k])){
					continue;
				}
			}
			
			$field="pa.options_values_id";
			$varlist=[];
			switch($_GET['main_page']){
				case FILENAME_SPECIALS:
					
					$sql="select ".$field." from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id(select products_id from ".TABLE_SPECIALS." where status=1) and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 and pa.options_id='".$k."' group by pa.options_values_id";
				break;
				case FILENAME_FEATURED_PRODUCTS:
					
					$sql="select ".$field." from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where p.products_id(select products_id from ".TABLE_FEATURED." where status=1) and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 and pa.options_id='".$k."' group by pa.options_values_id";

				break;
				case FILENAME_ADVANCED_SEARCH:
					if(isset($_GET['keyword'])){
						if(isset($_GET['cPath'])){
							$categories=$predata_class->getPredata(TABLE_CATEGORIES);
							$cids=$categories[$cid]['categories_sub_all_id'];
							if($cids=="none"){$cids=$cid;}
							
							//$sql="select ".$field." from ".TABLE_PRODUCTS." p left join ".TABLE_PRODUCTS_ATTRIBUTES." pa on p.products_id=pa.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in(".join(",",$var).")) and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=".(int)$_SESSION['languages_id']." and products_name like '%".$_GET['keyword']."%') and pa.options_id='".$k."' and p.products_status=1 group by pa.options_values_id";
							$sql="select ".$field." from ".TABLE_PRODUCTS." p left join ".TABLE_PRODUCTS_ATTRIBUTES." pa on p.products_id=pa.products_id where p.master_categories_id in(".$cids.") and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=".(int)$_SESSION['languages_id']." and products_name like '%".$_GET['keyword']."%') and pa.options_id='".$k."' and p.products_status=1 group by pa.options_values_id";
						}else{

							$sql="select ".$field." from ".TABLE_PRODUCTS." p left join ".TABLE_PRODUCTS_ATTRIBUTES." pa on p.products_id=pa.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=".(int)$_SESSION['languages_id']." and products_name like '%".$_GET['keyword']."%') and pa.options_id='".$k."' and p.products_status=1 group by pa.options_values_id";
						}
					}
				break;
				case FILENAME_ADVANCED_SEARCH_RESULT:
					if(isset($_GET['keyword'])){
						if(isset($_GET['cPath'])){
							$categories=$predata_class->getPredata(TABLE_CATEGORIES);
							$cids=$categories[$cid]['categories_sub_all_id'];
							if($cids=="none"){$cids=$cid;}
							
							//$sql="select ".$field." from ".TABLE_PRODUCTS." p left join ".TABLE_PRODUCTS_ATTRIBUTES." pa on p.products_id=pa.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in(".join(",",$var).")) and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=".(int)$_SESSION['languages_id']." and products_name like '%".$_GET['keyword']."%') and pa.options_id='".$k."' and p.products_status=1 group by pa.options_values_id";
							$sql="select ".$field." from ".TABLE_PRODUCTS." p left join ".TABLE_PRODUCTS_ATTRIBUTES." pa on p.products_id=pa.products_id where p.master_categories_id in(".$cids.") and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=".(int)$_SESSION['languages_id']." and products_name like '%".$_GET['keyword']."%') and pa.options_id='".$k."' and p.products_status=1 group by pa.options_values_id";
						}else{
							$sql="select ".$field." from ".TABLE_PRODUCTS." p left join ".TABLE_PRODUCTS_ATTRIBUTES." pa on p.products_id=pa.products_id where p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id=? and products_name like '%".$_GET['keyword']."%') and pa.options_id='".$k."' and p.products_status=1 group by pa.options_values_id";
						}
					}
				break;
				case FILENAME_PRODUCTS_ALL:
					$sql="select ".$field." from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where pa.options_id='".$k."' and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 group by pa.options_values_id";
				break;
				default:
					if(isset($_GET['cPath'])){
						$categories=$predata_class->getPredata(TABLE_CATEGORIES);
						$cids=$categories[$cid]['categories_sub_all_id'];
						if($cids=="none"){$cids=$cid;}
						//$sql="select ".$field." from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where pa.options_id='".$k."' and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in(".join(",",$var).")) and p.products_status='1' group by pa.options_values_id";
						$sql="select ".$field." from ".TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where pa.options_id='".$k."' and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.master_categories_id in(".$cids.") and p.products_status='1' group by pa.options_values_id";
					}else{
						$varlist[]=$_SESSION['languages_id'];
						$sql="select ".$field." from ".TABLE_PRODUCTS." p iner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id where pa.options_id='".$k."' and p.products_id in(select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') and p.products_status=1 group by pa.options_values_id";
					}
				break;
				
			}

			$options_values_ids=openzcQuery($sql);
			$options_values_ids=openzc_table_to_list($options_values_ids);
			
			$opvids=$full_id=array();
			foreach($options_values_ids as $a => $b){
				$opvids[]=$b['options_values_id'];
				$full_id[]=$b['options_values_id'];
			}

			$opvids=join(",",$opvids);

			$sqldata=$this->get_filter_sql("options",$GET,$k,"",$opvids);

			$data=openzcQuery($sqldata);
			
			$data=openzc_table_to_list($data,"options_values_id");
			//print_r($data);exit;

			$data=$this->get_default_data("options",$data,$k,$full_id);

			//print_r($data);exit;
			if(isset($filtered_options[$k]) && count($filtered_options[$k])>0){
				foreach($filtered_options[$k] as $a => $b){
					if(isset($data[$b])){
						$data[$b]['status']="active";

						if($mul==false){
							foreach($data as $c => $d){
								if($c!=$b){
									$data[$c]['filter_count']=0;
								}
							}
							//$array[$b]=$data[$b];
							//$data=array();
							//$data[$b]=$array[$b];
						}
					}
				}
			}

			//print_r($data);exit;
			foreach($data as $a => $b){
				
				$filtereds=$filtered_options;
				if($b['status']=="active"){
					unset($filtereds[$k][$a]);
				}else{
					$filtereds[$k][$b['options_values_id']]=$b['options_values_id'];
				}
				$b['filter_id']=$k."_".$b['options_values_id'];
				$b['filter_name']=$options_values[$a]['products_options_values_name'];
				$b['filter_image']=$options_values[$a]['products_options_values_image'];
				$b['filter_color']=$options_values[$a]['products_options_values_color'];
				
				if(isset($modules_options[$a])){
					if(isset($modules_options[$a]['image']) && $modules_options[$a]['image']){$b['filter_image']=$modules_options[$a]['image'];}
					if(isset($modules_options[$a]['color']) && $modules_options[$a]['color']){$b['filter_color']=$modules_options[$a]['color'];}
				}

				if($b['filter_count']>0){
					if(count($filtereds)>0){
						$parameter_filtereds=[];

						foreach($filtereds as $c => $d){
							if(count($d)>0){
								$parameter_filtereds[]=$c.":".join(",",$d);
							}
						}
						if(count($parameter_filtereds)>0){
							$b['filter_link']=zen_href_link($GET['main_page'],$parameter."&options=".join("|",$parameter_filtereds));
						}else{
							$b['filter_link']=zen_href_link($GET['main_page'],$parameter);
						}
					}else{
						$b['filter_link']=zen_href_link($GET['main_page'],$parameter);
					}
				}else{
					$b['filter_link']="javascript:void(0)";
				}
				$data[$a]=$b;
			}
		
			$result[$k]['filter_item']=$options[$k]['products_options_name'];
			$result[$k]['options_id']=$k;
			
			$result[$k]['values']=$data;
		
		}

		return $result;
	}
  
	
	function get_table_ids($array,$v){
		if($v=="true"){
			foreach($array as $k => $v){$str.=$v.",";}
		}else{
			foreach($array as $k => $v){$str.=$k.",";}
		}
		$str.="#";$str=str_replace(",#","",$str);
		$str.="#";$str=str_replace("#","",$str);
		return $str;
	}
	
	function get_options_values_ids($str,$values_id,$options_id,$mul){
		global $predata_class;
		//$products_options_values_to_products_options=$predata_class->getPredata(TABLE_PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS);
		$str=explode(",",$str);
		$str=array_filter($str);
		if(!$mul){
			foreach($str as $k => $v){
				if($products_options_values_to_products_options[$v]['products_options_id']==$options_id){$str[$k]=$values_id;$n++;break;}
			}
			if($n==0){$str[]=$values_id;}
		}
	
		if($mul==true){$str[]=$values_id;}
	  
		if(count($str)==1){$ids=$str[0];}
		else{
			$ids=array_unique($str);
			$ids=$this->get_table_ids($ids,"true");
		}
		return $ids;
	}
	
	function get_page_parameter($GET,$parameter){
	    
		foreach($GET as $k => $v){
			if($k!="main_page" && $k!=$parameter && $k!="page" && $k!="sort" && $k!="order" && $k!="disp_order" && $k!="search_in_description" && $k!="inc_subcat"){$str.=$k."=".$v."&";}
		}
		$str.="#";
		$str=str_replace("&#","",$str);
		$str=str_replace("#","",$str);
		
		return $str;
	}
	
	function get_price_section($min,$max,$space,$slide=''){
		global $currencies;
		$symbol=$currencies->currencies[$_SESSION['currency']]['symbol_left'];
		if($slide==true){
			
			$rs[0]['symbol']=$symbol;
		}else{
			if(!$space){$space=$max;}
			$space=number_format($space,2,".","");
			$space_rate=number_format($this->price_exchange_rate($space),2,".","");
		
			$n=$max/$space;
			if($n<1){$n=1;}
			$rs=array();
			$j=$l=0;
		
			for($i=0;$i<$n;$i++){
				$rs[$i]['filter_name']=$symbol.$j." - ".$symbol.($j+$space_rate);
				$rs[$i]['min']=$l;
				$rs[$i]['max']=$l+$space;
				$j=$j+$space_rate;
				$l=$l+$space;
			}
		}
		return $rs;
	}
	
	function price_exchange_rate($data){
		global $currencies;
	  
		if(is_array($data)){
			foreach($data as $k => $v){
				$rs[]=number_format($v*($currencies->currencies[$_SESSION['currency']]['value']),2,".","");
			}
		}else{
			$rs=number_format($data*($currencies->currencies[$_SESSION['currency']]['value']),2,".",""); 
		}
		
		return $rs;
	}
	private function get_current_cid($GET){
		global $predata_class;
		$categories=$predata_class->getPredata(TABLE_CATEGORIES);
		$cid=openzc_get_current_cpath($GET['cPath']);
		$cids=openzc_get_son_ids($categories,$cid,$cid);
		return $cids;
	}
	private function get_filter_sql($item,$GET,$range='',$mul=false,$opids=''){
		global $predata_class;
		$categories=$predata_class->getPredata(TABLE_CATEGORIES);
		
		$varlist=[];
		$table=TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id";

		if($item=="options" || $item=="price"){
			$field="count(distinct p.products_id) as filter_count";
		}else{
			$field="count(distinct p.products_id) as filter_count,p.manufacturers_id";
		}
		
		if($_GET['main_page']=="products_all"){
			$where="";
		}else{
			$cid=openzc_get_current_cpath($GET['cPath']);
			if($categories[$cid]['categories_sub_all_id']!="none"){
				$cid=$categories[$cid]['categories_sub_all_id'];
			}

			$cids=array_filter(explode(",",str_replace("none","",$cid)));
			
			//$where="p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in(".join(",",$var)."))";
			$where="p.master_categories_id in(".join(",",$cids).")";
		}
		
		switch($_GET['main_page']){
			case FILENAME_SPECIALS:
				$table=TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id";
				$where="p.products_id in(select products_id from ".TABLE_SPECIALS." where status=1)";
			break;
			case FILENAME_FEATURED_PRODUCTS:
				$table=TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_DESCRIPTION." pd on p.products_id=pd.products_id";
				$where="p.products_id in(select products_id from ".TABLE_FEATURED." where status=1)";
			break;
			case FILENAME_ADVANCED_SEARCH_RESULT:
				if(isset($_GET['keyword']) && $_GET['keyword']!='%'){
					$where="pd.products_name like '%".$_GET['keyword']."%'";
					if(isset($GET['cPath'])){
						//$where.=" and p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in('".$cid."'))";
						$where.=" and p.master_categories_id in('".$cid."')";
					}
				}
			break;
			case FILENAME_ADVANCED_SEARCH:
				if(isset($_GET['keyword']) && $_GET['keyword']!='%'){
					$where="pd.products_name like '%".$_GET['keyword']."%'";
					if(isset($GET['cPath'])){
						//$where.=" and p.products_id in(select products_id from ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id in('".$cid."'))";
						$where.=" and p.master_categories_id in('".$cid."')";
					}
				}
			break;
		}
		
		foreach($GET as $k => $v){
			$sql="";
			switch($k){
				case "brand":
					$v=array_filter(explode(",",$v));
					if($item!=$k){
						$v="'".join("','",$v)."'";
						$sql.=" and p.manufacturers_id in(".$v.")";
					}
					$where.=$sql;
				break;
				case "price":
					$v=array_filter(explode("|",$v));
					
					if($item!=$k){
						$first=key($v);
						foreach($v as $a => $b){
							$b=explode(",",$b);
							if(count($v)>1){
								if($first==$a){
									$sql.="(p.products_price_sorter>='".$b[0]."' and p.products_price_sorter < '".$b[1]."') ";
								}else{
									$sql.=" or (p.products_price_sorter>='".$b[0]."' and p.products_price_sorter < '".$b[1]."')";
								}
							}else{
								$sql.="p.products_price_sorter>='".$b[0]."' and p.products_price_sorter < '".$b[1]."'";
							}
						}
						$where.=" and (".$sql.")";
					}
					
				break;
				case "options":
					$v=array_filter(explode("|",$v));

					foreach($v as $a => $b){
						$array=array_filter(explode(":",$b));
						$values=array_filter(explode(",",$array[1]));
						foreach($values as $c => $d){
							$options[$array[0]]['values'][]=$d;
						}
						
					}
					if($range && $item==$k){
						unset($options[$range]);
						foreach($options as $a => $b){
							$vid=join(",",$b['values']);
							$sql.=" and p.products_id in ( select products_id from ".TABLE_PRODUCTS_ATTRIBUTES." where options_id in(".$a.") and options_values_id in(".$vid.") )";
						}
					}else{
						$table.=" left join ".TABLE_PRODUCTS_ATTRIBUTES." pa on pa.products_id=p.products_id";
						foreach($options as $a => $b){
							$vid=join(",",$b['values']);
							$sql.=" and p.products_id in ( select products_id from ".TABLE_PRODUCTS_ATTRIBUTES." where options_id in(".$a.") and options_values_id in(".$vid.") )";
						}
						$where.=" ";
					}
					$where.=$sql;
				break;
			}
		}
		if($item=="brand"){
			$where.=" and pd.language_id='".(int)$_SESSION['languages_id']."' and p.manufacturers_id<>0 group by p.manufacturers_id";
		}
		elseif($item=="price"){
			$price_group_sql_array=[];
			foreach($range as $k => $v){
				if($k==(count($range)-1)){
					$price_group_sql_array[]="sum(case when p.products_price_sorter>=".$v['min']." and p.products_price_sorter<=".$v['max']." then 1 else 0 end ) as price_group_".$k;
				}else{
					$price_group_sql_array[]="sum(case when p.products_price_sorter>=".$v['min']." and p.products_price_sorter<".$v['max']." then 1 else 0 end ) as price_group_".$k;
				}
			}
			$sql="select ".join(",",$price_group_sql_array)." from ".$table." where ".$where." and pd.language_id='".(int)$_SESSION['languages_id']."' and p.products_status=1";
		}
		elseif($item=="options"){
			$field.=",pa.options_values_id";
			$table=TABLE_PRODUCTS." p inner join ".TABLE_PRODUCTS_ATTRIBUTES." pa on p.products_id=pa.products_id";
			$where.=" and pa.options_id='".$range."' and p.products_id in ( select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."') group by pa.options_values_id";
			//$where.=" and pa.options_id='".$range."' and p.products_id in ( select products_id from ".TABLE_PRODUCTS_DESCRIPTION." where language_id='".(int)$_SESSION['languages_id']."')";
		}

		
			$sql="select ".$field." from ".$table." where p.products_status='1' and ".$where;
		
		return $sql;
	}
	function get_default_data($item="",$filter_data=array(),$options_id="",$full_id=""){
		$unset=array("options","brand","price");
		$GET=$_GET;
		foreach($unset as $k => $v){
			unset($GET[$v]);
		}
		if($item=="price"){
			$sql=$this->get_filter_sql("price",$GET,[$filter_data['0'],$filter_data['1'],$filter_data['2']],false);
			return $sql;
		}
		$sqldata=$this->get_filter_sql($item,$GET,$options_id,"",$full_id);
		$key="";
		if($item=="brand"){$key="manufacturers_id";}
		if($item=="options"){$key="options_values_id";}
		$data=openzcQuery($sqldata);
		$data=openzc_table_to_list($data,$key);
		
		foreach($data as $k => $v){
			if(!isset($filter_data[$k])){
				$v['filter_count']=0;
				$data[$k]=$v;
			}
		}
		return $data;
	}
}
?>