<!DOCTYPE html>
<html lang="en" dir="ltr" class="js windows chrome desktop page--no-banner page--logo-main page--show page--show card-fields cors svg opacity placeholder no-touchevents displaytable display-table generatedcontent cssanimations flexbox no-flexboxtweener anyflexbox no-shopemoji floating-labels" style="">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0, height=device-height, minimum-scale=1.0, user-scalable=0">
<meta name="referrer" content="origin">
<title>{openzc:define.HEADING_TITLE/}</title>
<meta data-browser="chrome" data-browser-major="86">
<meta data-body-font-family="-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol'" data-body-font-type="system">
<link href="/assets/system/css/checkout.css" rel="stylesheet">
</head>
<body>
{openzc:include filename="./aside_desktop.tpl"/}
<div class="content">
  <div class="wrap">
    <div class="main"> {openzc:include filename="./breadcrumb.tpl"/}
      <main class="main__content" role="main"> {openzc:include filename="./messagestack.tpl"/}
<div class="step" data-step="payment_method" data-last-step="true">
  <div class="step__sections">
    <div class="section">
      <div class="content-box">
        <div role="table" class="content-box__row content-box__row--tight-spacing-vertical">
          <div role="row" class="review-block">
            <div class="review-block__inner">
              <div role="rowheader" class="review-block__label"> Contact </div>
              <div role="cell" class="review-block__content">
                <bdo dir="ltr">{openzc:account field='customers_email_address'/}</bdo>
              </div>
            </div>
            <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}"> <span aria-hidden="true">Change</span> <span class="visually-hidden">Change contact information</span> </a> </div>
          </div>
          <div role="row" class="review-block">
            <div class="review-block__inner">
              <div role="rowheader" class="review-block__label"> Ship to {openzc:if $_SESSION['sendto']==$_SESSION['billto']}& Bill to{/openzc:if}</div>
              <div role="cell" class="review-block__content">
                <address class="address address--tight">
                {openzc:account item="address" default="true"}[field:address/]{/openzc:account}
                </address>
              </div>
            </div>
            <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}"> <span aria-hidden="true">Change</span></a> </div>
          </div>
			
          <div role="row" class="review-block">
            <div class="review-block__inner">
              <div role="rowheader" class="review-block__label"> Shippng </div>
              <div role="cell" class="review-block__content" > {openzc:modules item="shipping" active="true"/}</div>
              
            </div>
			<div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_SHIPPING'/}"> <span aria-hidden="true">Change</span></a></div>
          </div>
		  <div role="row" class="review-block">
            <div class="review-block__inner">
              <div role="rowheader" class="review-block__label">Payment </div>
              <div role="cell" class="review-block__content" >
				 
				  {openzc:if $_SESSION['payment']=="paypalwpp"}
				  <img class="offsite-payment-gateway-logo" src="/style/common/img/paypal.png"/>
				  {else}
				  {openzc:var name="$_SESSION['payment']"/}
				  {/openzc:if}
				  
			  </div>
				</div>
              <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_PAYMENT'/}"> <span aria-hidden="true">Change</span></a></div>
            
          </div>
		  {openzc:if $_SESSION['sendto']!=$_SESSION['billto']}
		  <div role="row" class="review-block">
            <div class="review-block__inner">
              <div role="rowheader" class="review-block__label"> Bill to </div>
              <div role="cell" class="review-block__content">
                <address class="address address--tight">
                {openzc:var name="$billing_address[address]"/}
                </address>
              </div>
            </div>
            <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_PAYMENT'/}"> <span aria-hidden="true">Change</span></a> </div>
          </div>
		  {/openzc:if}
		  <div role="row" class="review-block">
            <div class="review-block__inner">
              <div role="rowheader" class="review-block__label"> Comments </div>
              <div role="cell" class="review-block__content">
                {openzc:var name="$_SESSION['comments']"/}
              </div>
            </div>
            <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_SHIPPING'/}"> <span aria-hidden="true">Change</span></a> </div>
          </div>
        </div>
      </div>
    </div>
    
    <form class="edit_checkout animate-floating-labels" action="{openzc:var name='$form_action_url'/}" accept-charset="UTF-8" method="post" id="checkout_confirmation" onsubmit="submitonce();">
      <input type="hidden" name="securityToken" value="{openzc:field.securityToken/}"/>
      {openzc:if is_array($payment_modules->modules)}
      {openzc:echo}$process_button;{/openzc:echo}
	  {/openzc:if}
      <div class="step__footer" data-step-footer="">
        <div class="shown-if-js">
          <button type="submit" name="btn_submit_x" id="btn_submit" class="step__footer__continue-btn btn submit_button button_confirm_order" ><span class="btn__content">Pay now</span>
          <svg class="icon-svg icon-svg--size-18 btn__spinner icon-svg--spinner-button">
            <use xlink:href="#spinner-button"></use>
          </svg>
          </button>
        </div>
        
        <a class="step__footer__previous-link" href="{openzc:link name='FILENAME_CHECKOUT_PAYMENT'/}">
        <svg focusable="false" aria-hidden="true" class="icon-svg icon-svg--color-accent icon-svg--size-10 previous-link__icon" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10">
          <path d="M8 1L7 0 3 4 2 5l1 1 4 4 1-1-4-4"></path>
        </svg>
        <span class="step__footer__previous-link-content">Return to shipping</span></a>
	 </div>
    </form>
  </div>
</div>
</main>
<script type="text/javascript">

var submitter = null;
function popupWindow(url) {
  window.open(url,'popupWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=450,height=320,screenX=150,screenY=150,top=150,left=150')
}

function couponpopupWindow(url) {
  window.open(url,'couponpopupWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=450,height=320,screenX=150,screenY=150,top=150,left=150')
}

function submitFunction($gv,$total) {
   if ($gv >=$total) {
     submitter = 1;
   }
}

function submitonce()
{
  var button = document.getElementById("btn_submit");
  button.style.cursor="wait";
  button.disabled = true;
  setTimeout('button_timeout()', 4000);
  return false;
}
function button_timeout() {
  var button = document.getElementById("btn_submit");
  button.style.cursor="pointer";
  button.disabled = false;
}

</script>
      {openzc:include filename="./footer.tpl"/} </div>
    {openzc:include filename="./aside_mobile.tpl"/} </div>
</div>
</body>
{openzc:include filename="./javascript.tpl"/}
</html>