<!DOCTYPE html>
<html lang="en" dir="ltr" class="js windows chrome desktop page--no-banner page--logo-main page--show page--show card-fields cors svg opacity placeholder no-touchevents displaytable display-table generatedcontent cssanimations flexbox no-flexboxtweener anyflexbox no-shopemoji floating-labels" style="">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0, height=device-height, minimum-scale=1.0, user-scalable=0">
<meta name="referrer" content="origin">
<title>{openzc:define.HEADING_TITLE/}</title>
<meta data-browser="chrome" data-browser-major="86">
<meta data-body-font-family="-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol'" data-body-font-type="system">
<link href="{openzc:field.template/}/assets/system/css/checkout.css" rel="stylesheet">
</head>
<body>
{openzc:include filename="./aside_desktop.tpl"/}
<div class="content">
  <div class="wrap">
    <div class="main"> {openzc:include filename="./breadcrumb.tpl"/}
      <main class="main__content" role="main">
      
      {openzc:include filename="./messagestack.tpl"/}
        <div class="step" >
          <form class="edit_checkout animate-floating-labels" action="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}" accept-charset="UTF-8" method="post">
            <input type="hidden" name="securityToken" value="{openzc:field.securityToken/}"/>
            <input type="hidden" name="action" value="process"/>
            <div class="step__sections">
              <div class="section section--contact-information">
                <div class="section__header">
                  <div class="layout-flex layout-flex--tight-vertical layout-flex--loose-horizontal layout-flex--wrap">
                    <h2 class="section__title layout-flex__item layout-flex__item--stretch" id="main-header" tabindex="-1"> Contact Method </h2>
                    {openzc:if !$loginStatus}
                    <p class="layout-flex__item"> <span aria-hidden="true">Do you have an account?</span> <a href="{openzc:link name='FILENAME_LOGIN'/}"> Sign in </a> </p>
                    {/openzc:if} </div>
                </div>
                <div class="section__content" >
                  <div class="fieldset">
                    <div class="field field--email {openzc:if isset($information_errors['email_address'])}field--error{/openzc:if}">
                      <div class="field__input-wrapper">
                        <label class="field__label field__label--visible" for="checkout_email">{openzc:define.ENTRY_EMAIL_ADDRESS/} <code>{openzc:define.ENTRY_EMAIL_ADDRESS_TEXT/}</code></label>
                        <input value="{openzc:account field='customers_email_address'/}" name="email_address" placeholder="{openzc:define.ENTRY_EMAIL_ADDRESS/}" spellcheck="false" class="field__input" size="30" type="email" id="checkout_email">
                      </div>
                      {openzc:if isset($information_errors['email_address'])}
                      <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['email_address']"/}</p>
                      {/openzc:if} </div>
                  </div>
                  {openzc:if ACCOUNT_NEWSLETTER_STATUS=="1"}
                  <div class="fieldset-description" >
                    <div class="section__content">
                      <div class="checkbox-wrapper">
                        <div class="checkbox__input">
                          <input class="input-checkbox" type="checkbox" value="1" checked="checked" name="newsletter" id="checkout_buyer_accepts_marketing">
                        </div>
                        <label class="checkbox__label" for="checkout_buyer_accepts_marketing">{openzc:define.ENTRY_NEWSLETTER/}</label>
                      </div>
                    </div>
                  </div>
                  <input type="hidden" name="email_format" value="HTML">
                  {/openzc:if} </div>
              </div>
              <div class="section section--shipping-address">
                <div class="section__content"> {openzc:if ACCOUNT_GENDER=="true"}
                  <div class="section">
                    <div class="section__header">
                      <h2 class="section__title"> {openzc:define.ENTRY_GENDER/} </h2>
                    </div>
                    <div class="section__content">
                      <div class="fieldset">
                        <div class="address-fields" >
                          <div class="field field--required field--quarter">
                            <div class="radio-wrapper">
                              <div class="radio__input">
                                <input class="input-radio" type="radio" value="m" checked="" name="gender" id="checkout_shipping_gender_m">
                              </div>
                              <label class="radio__label" for="checkout_shipping_gender_m"> <span class="radio__label__primary" > {openzc:define.MALE/} </span> </label>
                            </div>
                          </div>
                          <div class="field field--required field--quarter">
                            <div class="radio-wrapper">
                              <div class="radio__input">
                                <input class="input-radio" type="radio" value="f" name="gender" id="checkout_shipping_gender_f">
                              </div>
                              <label class="radio__label" for="checkout_shipping_gender_f"> <span class="radio__label__primary" > {openzc:define.FEMALE/} </span> </label>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  {/openzc:if}
                  <div class="section">
                    <div class="section__header">
                      <h2 class="section__title"> {openzc:define.TABLE_HEADING_ADDRESS_DETAILS/} </h2>
                    </div>
                    <div class="section__content">
                      <div class="fieldset">
                        <div class="address-fields" >
                          <div class="field field--required field--half {openzc:if isset($information_errors['firstname'])}field--error{/openzc:if}">
                            <div class="field__input-wrapper">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_first_name"> {openzc:define.ENTRY_FIRST_NAME/} <code>{openzc:define.ENTRY_FIRST_NAME_TEXT/}</code> </label>
                              <input placeholder="First name" autocorrect="off" class="field__input" size="30" type="text" value="{openzc:account field='customers_firstname'/}" name="firstname" id="checkout_shipping_address_first_name">
                            </div>
                            {openzc:if isset($information_errors['firstname'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['firstname']"/}</p>
                            {/openzc:if} </div>
                          <div class="field field--required field--half {openzc:if isset($information_errors['lastname'])}field--error{/openzc:if}">
                            <div class="field__input-wrapper">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_last_name"> {openzc:define.ENTRY_LAST_NAME/} <code>{openzc:define.ENTRY_LAST_NAME_TEXT/}</code> </label>
                              <input placeholder="Last name" autocorrect="off" data-backup="last_name" class="field__input" size="30" type="text" value="{openzc:account field='customers_lastname'/}" name="lastname" id="checkout_shipping_address_last_name">
                            </div>
                            {openzc:if isset($information_errors['lastname'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['lastname']"/}</p>
                            {/openzc:if} </div>
                          {openzc:if ACCOUNT_COMPANY=="true"}
                          <div data-address-field="company" class="field field--optional">
                            <div class="field__input-wrapper">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_company">{openzc:define.ENTRY_COMPANY/} <code>{openzc:define.ENTRY_COMPANY_TEXT/}</code></label>
                              <input placeholder="{openzc:define.ENTRY_COMPANY/}" autocorrect="off" class="field__input" size="30" type="text" value="{openzc:account field='customers_company/}" name="company" id="checkout_shipping_address_company">
                            </div>
                          </div>
                          {/openzc:if}
                          <div data-address-field="address1" class="field field--required {openzc:if isset($information_errors['street_address'])}field--error{/openzc:if}">
                            <div class="field__input-wrapper">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_address1"> {openzc:define.ENTRY_STREET_ADDRESS/} <code>{openzc:define.ENTRY_STREET_ADDRESS_TEXT/}</code> </label>
                              <input placeholder="{openzc:define.ENTRY_STREET_ADDRESS/}" autocorrect="off" role="combobox" class="field__input" size="30" type="text" value="{openzc:account field='customers_street_address'/}" name="street_address" id="checkout_shipping_address_address1">
                            </div>
                            <input type="hidden" name="should_be_empty" value=""/>
                            {openzc:if isset($information_errors['street_address'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['street_address']"/}</p>
                            {/openzc:if} </div>
                          {openzc:if ACCOUNT_SUBURB=="true"}
                          <div data-address-field="address2" class="field field--optional">
                            <div class="field__input-wrapper">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_address2"> {openzc:define.ENTRY_SUBURB/} <code>{openzc:define.ENTRY_SUBURB_TEXT/}</code> </label>
                              <input placeholder="" autocorrect="off" class="field__input" size="30" type="text" value="{openzc:account field='customers_suburb'/}" name="suburb" id="checkout_shipping_address_address2">
                            </div>
                          </div>
                          {/openzc:if}
                          <div data-address-field="city" class="field field--required {openzc:if isset($information_errors['city'])}field--error{/openzc:if}">
                            <div class="field__input-wrapper">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_city"> {openzc:define.ENTRY_CITY/} <code>{openzc:define.ENTRY_CITY_TEXT/}</code> </label>
                              <input placeholder="{openzc:define.ENTRY_CITY/}" autocorrect="off" class="field__input" size="30" type="text" value="{openzc:account field='customers_city'/}" name="city" id="checkout_shipping_address_city">
                            </div>
                            {openzc:if isset($information_errors['city'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['city']"/}</p>
                            {/openzc:if} </div>
                          <div class="field field--required field--third">
                            <div class="field__input-wrapper field__input-wrapper--select">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_country"> {openzc:define.ENTRY_COUNTRY/} <code>{openzc:define.ENTRY_COUNTRY_TEXT/}</code> </label>
                              <select size="1" class="field__input field__input--select openzc-select" data-action="getState" data-reload="CheckoutState" name="zone_country_id" id="checkout_shipping_address_country" placeholder="{openzc:define.ENTRY_COUNTRY/}">
                      {openzc:var name='$countries'}
                                <option value="[field:id/]" {openzc:if $field['status']}selected=""{/openzc:if}>[field:text/]</option>
                      {/openzc:var}
                              </select>
                              <div class="field__caret"> <svg class="icon-svg icon-svg--color-adaptive-lighter icon-svg--size-10 field__caret-svg" role="presentation">
                                <use xlink:href="#caret-down"></use>
                                </svg> </div>
                            </div>
                          </div>
                          <div class="field field--required field--third {openzc:if isset($information_errors['state']) || isset($information_errors['zone_id'])}field--error{/openzc:if}">
                            <div class="field__input-wrapper field__input-wrapper--select">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_province">{openzc:define.ENTRY_STATE/}</label>
                              {openzc:ajax filename="CheckoutState"}
                              {openzc:if count($states)>1}
                              <select placeholder="{openzc:define.ENTRY_STATE/}" autocorrect="off" class="field__input field__input--select" name="zone_id" id="checkout_shipping_address_province">
                                
                          {openzc:var name='$states'}
                              
                                <option value="[field:id/]" {openzc:if $field['status']}selected=""{/openzc:if}>[field:text/]</option>
                                
                          {/openzc:var}
                      
                              </select>
                              <div class="field__caret shown-if-js"> <svg class="icon-svg icon-svg--color-adaptive-lighter icon-svg--size-10 field__caret-svg" role="presentation">
                                <use xlink:href="#caret-down"></use>
                                </svg> </div>
                              {else}
                              
                              <input placeholder="{openzc:define.ENTRY_STATE/}" autocorrect="off" class="field__input field__input--province" size="30" type="text" value="{openzc:account field='customers_state'/}" name="state" id="checkout_shipping_address_province">
                              {/openzc:if}
                              {/openzc:ajax} </div>
                            {openzc:if isset($information_errors['state'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['state']"/}</p>
                            {/openzc:if}
                            {openzc:if isset($information_errors['zone_id'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['zone_id']"/}</p>
                            {/openzc:if} </div>
                          <div class="field field--required field--third {openzc:if isset($information_errors['postcode'])}field--error{/openzc:if}">
                            <div class="field__input-wrapper">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_zip">{openzc:define.ENTRY_POST_CODE/}</label>
                              <input placeholder="Postal code" autocorrect="off" class="field__input field__input--zip" size="30" type="text" value="{openzc:account field='customers_postcode'/}" name="postcode" id="checkout_shipping_address_zip">
                            </div>
                            {openzc:if isset($information_errors['postcode'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['postcode']"/}</p>
                            {/openzc:if} </div>
                          <div class="field field--required {openzc:if isset($information_errors['telephone'])}field--error{/openzc:if}">
                            <div class="field__input-wrapper field__input-wrapper--icon-right">
                              <label class="field__label field__label--visible" for="checkout_shipping_address_phone"> {openzc:define.ENTRY_TELEPHONE_NUMBER/} <code>{openzc:define.ENTRY_TELEPHONE_NUMBER_TEXT/}</code> </label>
                              <input placeholder="Phone number" autocorrect="off" class="field__input field__input--numeric" size="30" type="tel" value="{openzc:account field='customers_telephone'/}" name="telephone" id="checkout_shipping_address_phone">
                              <div class="field__icon">
                                <div data-tooltip="true" id="phone_tooltip" class="tooltip-container">
                                  <button type="button" class="tooltip-control" placeholder="Phone number"> <svg class="icon-svg icon-svg--color-adaptive-lighter icon-svg--size-16 icon-svg--block icon-svg--center" role="presentation" hidden="true" focusable="false">
                                  <use xlink:href="#question"></use>
                                  </svg> </button>
                                  <span class="tooltip" role="tooltip" id="tooltip-for-phone">Should we need to contact you about your order </span> </div>
                              </div>
                            </div>
                            {openzc:if isset($information_errors['telephone'])}
                            <p class="field__message field__message--error" id="error-for-email">{openzc:var name="$information_errors['telephone']"/}</p>
                            {/openzc:if} </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="section section--billing-address" >
        <div class="section__header">
          <h2 class="section__title">Billing address</h2>
          <p class="section__text"> Select the address that matches your card or payment method. </p>
        </div>
        <div class="section__content">
          <fieldset class="content-box">
            <legend class="visually-hidden">Choose a billing address</legend>
            <div class="radio-wrapper content-box__row" >
              <div class="radio__input">
                <input class="input-radio" type="radio" value="false" {openzc:if $_SESSION['sendto']==$_SESSION['billto']}checked="checked"{/openzc:if} name="billing_address_different" value="false" id="checkout_different_billing_address_false">
              </div>
              <label class="radio__label content-box__emphasis" for="checkout_different_billing_address_false"> Same as shipping address </label>
            </div>
            <div class="radio-wrapper content-box__row">
              <div class="radio__input">
                <input class="input-radio" type="radio" value="true" {openzc:if $_SESSION['sendto']!=$_SESSION['billto']}checked="checked"{/openzc:if} name="billing_address_different" id="checkout_different_billing_address_true">
              </div>
              <label class="radio__label content-box__emphasis" for="checkout_different_billing_address_true"> Use a different billing address </label>
            </div>
            <div class="radio-group__row content-box__row content-box__row--secondary {openzc:if $_SESSION['sendto']==$_SESSION['billto'] && !$billto_errors}hidden{/openzc:if}" id="section--billing-address__different">
              <div class="fieldset">
                <div class="address-fields">
                  <div class="field field--required field--half {openzc:if isset($billto_errors['firstname'])}field--error{/openzc:if}">
                    <div class="field__input-wrapper">
                      <label class="field__label field__label--visible" for="billto_address_first_name">{openzc:define.ENTRY_FIRST_NAME/} {openzc:define.ENTRY_FIRST_NAME_TEXT/}</label>
                      <input placeholder="{openzc:define.ENTRY_FIRST_NAME/} {openzc:define.ENTRY_FIRST_NAME_TEXT/}" class="field__input" size="30" type="text" name="billing_address[firstname]" id="billto_address_first_name" value="{openzc:var name='$billing_address[firstname]'/}">
                    </div>
                    {openzc:if isset($billto_errors['firstname'])}
                    <p class="field__message field__message--error" id="error-for-first_name">{openzc:var name="$billto_errors['firstname']"/}</p>
                    {/openzc:if}
          </div>
                  <div class="field field--required field--half {openzc:if isset($billto_errors['lastname'])}field--error{/openzc:if}">
                    <div class="field__input-wrapper">
            <label class="field__label field__label--visible" for="billto_address_last_name">{openzc:define.ENTRY_LAST_NAME/} {openzc:define.ENTRY_LAST_NAME_TEXT/}</label>
                      <input placeholder="{openzc:define.ENTRY_LAST_NAME/} {openzc:define.ENTRY_LAST_NAME_TEXT/} " class="field__input" size="30" type="text" name="billing_address[lastname]" id="billto_address_last_name" value="{openzc:var name='$billing_address[lastname]'/}">
                    </div>
          {openzc:if isset($billto_errors['lastname'])}
                    <p class="field__message field__message--error" id="error-for-lastname">{openzc:var name="$billto_errors['lastname']"/}</p>
                    {/openzc:if}
                  </div>
                  <div class="field field--required {openzc:if isset($billto_errors['street_address'])}field--error{/openzc:if}">
                    <div class="field__input-wrapper">
            <label class="field__label field__label--visible" for="billto_street_address">{openzc:define.ENTRY_STREET_ADDRESS/} {openzc:define.ENTRY_STREET_ADDRESS_TEXT/}</label>
                      <input placeholder="{openzc:define.ENTRY_STREET_ADDRESS/} {openzc:define.ENTRY_STREET_ADDRESS_TEXT/}" class="field__input" size="30" type="text" name="billing_address[street_address]" id="billto_street_address" value="{openzc:var name='$billing_address[street_address]'/}">
                     
                    </div>
          {openzc:if isset($billto_errors['street_address'])}
                    <p class="field__message field__message--error" id="error-for-street_address">{openzc:var name="$billto_errors['street_address']"/}</p>
                    {/openzc:if}
                  </div>
                  <div class="field field--optional">
                    <div class="field__input-wrapper">
            <label class="field__label field__label--visible" for="billto_suburb">{openzc:define.ENTRY_SUBURB/} {openzc:define.ENTRY_SUBURB_TEXT/}</label>
                      <input placeholder="{openzc:define.ENTRY_SUBURB/} {openzc:define.ENTRY_SUBURB_TEXT/} " class="field__input" size="30" type="text" name="billing_address[suburb]" id="billto_suburb" value="{openzc:var name='$billing_address[suburb]'/}">
                    </div>
                  </div>
                  <div class="field field--required {openzc:if isset($billto_errors['city'])}field--error{/openzc:if}">
                    <div class="field__input-wrapper">
            <label class="field__label field__label--visible" for="billto_city">{openzc:define.ENTRY_CITY/} {openzc:define.ENTRY_CITY_TEXT/}</label>
                      <input placeholder="{openzc:define.ENTRY_CITY/} {openzc:define.ENTRY_CITY_TEXT/}" class="field__input" aria-required="true" size="30" type="text" name="billing_address[city]" id="checkout_billing_address_city" value="{openzc:var name='$billing_address[city]'/}">
                    </div>
          {openzc:if isset($billto_errors['city'])}
                    <p class="field__message field__message--error" id="error-for-city">{openzc:var name="$billto_errors['city']"/}</p>
                    {/openzc:if}
                  </div>
                  <div class="field field--required field--third field--show-floating-label">
                    <div class="field__input-wrapper field__input-wrapper--select">
                      <label class="field__label field__label--visible" for="checkout_billing_address_country">{openzc:define.ENTRY_COUNTRY/} {openzc:define.ENTRY_COUNTRY_TEXT/}</label>
                      <select size="1" class="field__input field__input--select openzc-select" data-action="getState" data-reload="CheckoutBillState" name="billing_address[country_id]" id="checkout_shipping_address_country" placeholder="{openzc:define.ENTRY_COUNTRY/}">
                        {openzc:var name='$countries'}
                        <option value="[field:id/]" {openzc:if $field['id']==$billing_address['country_id']}selected=""{/openzc:if}>[field:text/]</option>
                        {/openzc:var}
                      </select>
                      <div class="field__caret">
                        <svg class="icon-svg icon-svg--color-adaptive-lighter icon-svg--size-10 field__caret-svg" role="presentation" >
                          <use xlink:href="#caret-down"></use>
                        </svg>
                      </div>
                    </div>
                  </div>
                  <div class="field field--required field--show-floating-label field--third {openzc:if isset($billto_errors['state']) || isset($billto_errors['zone_id'])}field--error{/openzc:if}">
                    <div class="field__input-wrapper field__input-wrapper--select ">
                      <label class="field__label field__label--visible" for="checkout_shipping_address_province">{openzc:define.ENTRY_STATE/}</label>
                      {openzc:ajax filename="CheckoutBillState"}
                      {openzc:if count($states_billing)>1}
                      <select placeholder="{openzc:define.ENTRY_STATE/}" autocorrect="off" class="field__input field__input--select" name="billing_address[zone_id]" id="checkout_shipping_address_province">
            {openzc:var name='$states_billing'} 
                        <option value="[field:id/]" {openzc:if $field['id']==$billing_address['zone_id']}selected=""{/openzc:if}>[field:text/]</option>
                        {/openzc:var}  
                      </select>
                      <div class="field__caret shown-if-js">
                        <svg class="icon-svg icon-svg--color-adaptive-lighter icon-svg--size-10 field__caret-svg" role="presentation">
                          <use xlink:href="#caret-down"></use>
                        </svg>
                      </div>
                      {else}
            {openzc:if isset($billing_address[state])}
                        <input placeholder="{openzc:define.ENTRY_STATE/}" class="field__input field__input--province" size="30" type="text" name="billing_address[state]" value="{openzc:var name='$billing_address[state]'/}" id="checkout_shipping_address_province">
            {else}
            <input placeholder="{openzc:define.ENTRY_STATE/}" class="field__input field__input--province" size="30" type="text" name="billing_address[state]" value="" id="checkout_shipping_address_province">
            {/openzc:if}
                      {/openzc:if}
                      {/openzc:ajax}
          </div>
           
                    {openzc:if isset($billto_errors['state'])}
                    <p class="field__message field__message--error" id="error-for-state">{openzc:var name="$billto_errors['state']"/}</p>
                    {/openzc:if}
          {openzc:if isset($billto_errors['zone_id'])}
                    <p class="field__message field__message--error" id="error-for-state">{openzc:var name="$billto_errors['zone_id']"/}</p>
                    {/openzc:if}
          </div>
                  <div class="field field--required field--third {openzc:if isset($billto_errors['postcode'])}field--error{/openzc:if}" >
                    <div class="field__input-wrapper">
          <label class="field__label field__label--visible" for="billto_postcode">{openzc:define.ENTRY_POST_CODE/} {openzc:define.ENTRY_POST_CODE_TEXT/}</label>
                      <input placeholder="{openzc:define.ENTRY_POST_CODE/} {openzc:define.ENTRY_POST_CODE_TEXT/}" class="field__input field__input--zip" size="30" type="text" name="billing_address[postcode]" id="checkout_billing_address_zip" value="{openzc:var name='$billing_address[postcode]'/}">
                    </div>
          {openzc:if isset($billto_errors['postcode'])}
                    <p class="field__message field__message--error" id="error-for-state">{openzc:var name="$billto_errors['postcode']"/}</p>
                    {/openzc:if}
                  </div>
                  
                </div>
              </div>
            </div>
          </fieldset>
        </div>
      </div>
            <div class="step__footer">
              <button type="submit" id="continue_button" class="step__footer__continue-btn btn" aria-busy="false"><span class="btn__content" >Continue to shipping method</span> <svg class="icon-svg icon-svg--size-18 btn__spinner icon-svg--spinner-button" aria-hidden="true" focusable="false">
              <use xlink:href="#spinner-button"></use>
              </svg> </button>
              <a class="step__footer__previous-link" href="{openzc:link name='FILENAME_SHOPPING_CART'/}"> <svg focusable="false" aria-hidden="true" class="icon-svg icon-svg--color-accent icon-svg--size-10 previous-link__icon" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10">
              <path d="M8 1L7 0 3 4 2 5l1 1 4 4 1-1-4-4"></path>
              </svg> <span class="step__footer__previous-link-content">Back to cart</span></a> </div>
          </form>
        </div>
      </main>
      {openzc:include filename="./footer.tpl"/} </div>
    {openzc:include filename="./aside_mobile.tpl"/} </div>
</div>
</body>
{openzc:include filename="./javascript.tpl"/}
</html>