<!DOCTYPE html>
<html lang="en" dir="ltr" class="js windows chrome desktop page--no-banner page--logo-main page--show page--show card-fields cors svg opacity placeholder no-touchevents displaytable display-table generatedcontent cssanimations flexbox no-flexboxtweener anyflexbox no-shopemoji floating-labels" style="">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0, height=device-height, minimum-scale=1.0, user-scalable=0">
<meta name="referrer" content="origin">
<title>{openzc:define.HEADING_TITLE/}</title>
<meta data-browser="chrome" data-browser-major="86">
<meta data-body-font-family="-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol'" data-body-font-type="system">
<link href="/assets/system/css/checkout.css" rel="stylesheet">
</head>
<body>
{openzc:include filename="./aside_desktop.tpl"/}
<div class="content">
  <div class="wrap">
    <div class="main"> {openzc:include filename="./breadcrumb.tpl"/}
      <main class="main__content" role="main"> {openzc:include filename="./messagestack.tpl"/}
        <div class="step" data-step="payment_method" data-last-step="true">
          <div class="step__sections">
            <div class="section">
              <div class="content-box">
                <div role="table" class="content-box__row content-box__row--tight-spacing-vertical">
                  <div role="row" class="review-block">
                    <div class="review-block__inner">
                      <div role="rowheader" class="review-block__label"> Contact </div>
                      <div role="cell" class="review-block__content">
                        <bdo dir="ltr">{openzc:account field='customers_email_address'/}</bdo>
                      </div>
                    </div>
                    <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}"> <span aria-hidden="true">Change</span> <span class="visually-hidden">Change contact information</span> </a> </div>
                  </div>
                  <div role="row" class="review-block">
                    <div class="review-block__inner">
                      <div role="rowheader" class="review-block__label"> Ship to </div>
                      <div role="cell" class="review-block__content">
                        <address class="address address--tight">
                        {openzc:account item="address" default="true"}[field:address/]{/openzc:account}
                        </address>
                      </div>
                    </div>
                    <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}"> <span aria-hidden="true">Change</span></a> </div>
                  </div>
                  <div role="row" class="review-block">
                    <div class="review-block__inner">
                      <div role="rowheader" class="review-block__label"> Method </div>
                      <div role="cell" class="review-block__content" > {openzc:modules item="shipping" active="true"/}</div>
                    </div>
                    <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_SHIPPING'/}"> <span aria-hidden="true">Change</span></a></div>
                  </div>
                  <div role="row" class="review-block">
                    <div class="review-block__inner">
                      <div role="rowheader" class="review-block__label"> Comments </div>
                      <div role="cell" class="review-block__content"> {openzc:var name="$_SESSION['comments']"/} </div>
                    </div>
                    <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_SHIPPING'/}"> <span aria-hidden="true">Change</span></a> </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="section section--reductions hidden-on-desktop">
              <div class="section__header">
                <h2 class="section__title">Gift card or discount code</h2>
              </div>
              <div class="section__content">
                <div data-reduction-form="">
                  <form class="edit_checkout animate-floating-labels openzc-form" accept-charset="UTF-8">
                    <input type="hidden" name="securityToken" value="{openzc:field.securityToken/}"/>
                    <input type="hidden" name="action" value="getCoupon"/>
                    <input type="hidden" name="reload" value="orderTotal"/>
                    <div class="fieldset"> {openzc:ajax filename="payment_coupon"}
                      <div class="field">
                        <div class="field__input-btn-wrapper">
                          <div class="field__input-wrapper">
                            <label class="field__label field__label--visible" for="checkout_reduction_code_mobile">Gift card or discount code</label>
                            {openzc:if empty($_SESSION['cc_id'])}
                            <input placeholder="Gift card or discount code" class="field__input" id="checkout_reduction_code_mobile" autocomplete="off" size="30" type="text" name="dc_redeem_code">
                            {else}
                            <input placeholder="Discount code used！" disabled="" class="field__input" id="checkout_reduction_code_mobile" autocomplete="off" size="30" type="text" >
                            {/openzc:if} </div>
                          {openzc:if !empty($_SESSION['cc_id'])}
                          <button name="button" type="submit" class="field__input-btn btn btn--disabled" disabled="">
                          {else}
                          <button name="button" type="submit" class="field__input-btn btn"> {/openzc:if} <span class="btn__content visually-hidden-on-mobile" aria-hidden="true"> Apply </span> <span class="visually-hidden"> Apply Discount Code </span> <svg class="icon-svg icon-svg--size-16 btn__icon shown-on-mobile" aria-hidden="true" focusable="false">
                          <use xlink:href="#arrow"></use>
                          </svg> <svg class="icon-svg icon-svg--size-18 btn__spinner icon-svg--spinner-button" aria-hidden="true" focusable="false">
                          <use xlink:href="#spinner-button"></use>
                          </svg> </button>
                        </div>
                      </div>
                      {/openzc:ajax} </div>
                  </form>
                </div>
              </div>
            </div>   
            <form name="checkout_payment" class="edit_checkout animate-floating-labels" action="{openzc:link name='FILENAME_CHECKOUT_CONFIRMATION'/}" accept-charset="UTF-8" method="post">
              <input type="hidden" name="securityToken" value="{openzc:field.securityToken/}"/>
              <div class="section section--payment-method" >
                <div class="section__header">
                  <h2 class="section__title" id="main-header"> Payment </h2>
                  <p class="section__text"> All transactions are secure and encrypted. </p>
                </div>
                <div class="section__content">
                  <div> 
                    <fieldset class="content-box">
                      {openzc:modules item="payment"}
                      {openzc:if $field['id']=="Isafeccline"}
                      {openzc:include filename="./credit.tpl"/}
                      {else}
                      <div class="radio-wrapper content-box__row ">
                        <div class="radio__input">
                          <input class="input-radio checkout_payment_gateway" id="checkout_payment_gateway_[field:id/]" type="radio" {openzc:if $field['status']=="active"}checked=""{/openzc:if} value="[field:id/]" name="payment" >
                        </div>
                        <div class="radio__label">
                          <label for="checkout_payment_gateway_[field:id/]" class="radio__label__primary content-box__emphasis payment-method"> {openzc:if $field['id']=="paypal"} <img class="offsite-payment-gateway-logo" src="/assets/system/img/paypal.png"/> {else}
                            [field:module/]
                            {/openzc:if} </label>
                        </div>
                      </div>
                      {openzc:if $field['id']=="paypal"}
                      <div id="payment-gateway-subfields-[field:id/]" class="radio-wrapper payment-gateway-subfields content-box__row content-box__row--secondary card-fields-container card-fields-container--loaded card-fields-container--transitioned {openzc:if $field['status']!="active"}hidden{/openzc:if}">
                        <div class="blank-slate"> <i class="blank-slate__icon icon icon--offsite"></i>
                          <p class="shown-if-js"> After clicking “Complete order”, you will be redirected to <b>{openzc:if $field['id']=="paypal"}Paypal{else}[field:module/]{/openzc:if}</b> to complete your purchase securely. </p>
                        </div>
                      </div>
                      {/openzc:if}
                      {/openzc:if}
                      {/openzc:modules}
                    </fieldset>
                  </div>
                </div>
              </div>
              
              <div class="step__footer" data-step-footer="">
                <div class="shown-if-js">
               
                  <button type="submit" id="continue_button" class="step__footer__continue-btn btn"><span class="btn__content">Pay now</span> <svg class="icon-svg icon-svg--size-18 btn__spinner icon-svg--spinner-button">
                  <use xlink:href="#spinner-button"></use>
                  </svg> </button>
                </div>
                <a class="step__footer__previous-link" href="{openzc:link name='FILENAME_CHECKOUT_SHIPPING'/}"> <svg focusable="false" aria-hidden="true" class="icon-svg icon-svg--color-accent icon-svg--size-10 previous-link__icon" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10">
                <path d="M8 1L7 0 3 4 2 5l1 1 4 4 1-1-4-4"></path>
                </svg> <span class="step__footer__previous-link-content">Return to shipping</span></a> </div>
            </form>
            
          </div>
        </div>
      
      </main>
      {openzc:include filename="./footer.tpl"/} </div>
    {openzc:include filename="./aside_mobile.tpl"/} </div>
</div>
</body>
{openzc:include filename="./javascript.tpl"/}
</html>