<!DOCTYPE html>
<html lang="en" dir="ltr" class="js windows chrome desktop page--no-banner page--logo-main page--show page--show card-fields cors svg opacity placeholder no-touchevents displaytable display-table generatedcontent cssanimations flexbox no-flexboxtweener anyflexbox no-shopemoji floating-labels" style="">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0, height=device-height, minimum-scale=1.0, user-scalable=0">
<meta name="referrer" content="origin">
<title>{openzc:define.HEADING_TITLE/}</title>
<meta data-browser="chrome" data-browser-major="86">
<meta data-body-font-family="-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol'" data-body-font-type="system">
<link href="/assets/system/css/checkout.css" rel="stylesheet">
</head>
<body>
{openzc:include filename="./aside_desktop.tpl"/}
<div class="content">
  <div class="wrap">
    <div class="main"> {openzc:include filename="./breadcrumb.tpl"/}
      <main class="main__content" role="main">
        <div class="step" data-step="shipping_method" data-last-step="false">
          <form class="edit_checkout" action="{openzc:link name='FILENAME_CHECKOUT_SHIPPING'/}" method="post">
            <input type="hidden" name="securityToken" value="{openzc:field.securityToken/}"/>
            <input type="hidden" name="action" value="process">
            <div class="step__sections">
              <div class="section"> 
                <div class="content-box">
                  <div role="table" class="content-box__row content-box__row--tight-spacing-vertical">
                    <div role="row" class="review-block">
                      <div class="review-block__inner">
                        <div role="rowheader" class="review-block__label"> Contact </div>
                        <div role="cell" class="review-block__content">
                          <bdo dir="ltr">{openzc:account field='customers_email_address'/}</bdo>
                        </div>
                      </div>
                      <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}"> <span>Change</span> </a> </div>
                    </div>
                    <div role="row" class="review-block">
                      <div class="review-block__inner">
                        <div role="rowheader" class="review-block__label"> Ship to </div>
                        <div role="cell" class="review-block__content">
                          <address class="address address--tight">
                          {openzc:account item="address" default="true"}[field:address/]{/openzc:account}
                          <address>
                          </address>
                          </address>
                        </div>
                      </div>
                      <div role="cell" class="review-block__link"> <a class="link--small" href="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}"> <span>Change</span> </a> </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="section section--shipping-method">
                <div class="section__header">
                  <h2 class="section__title" id="main-header" tabindex="-1"> Shipping method </h2>
                </div>
                <div class="section__content">
                  <div class="content-box" > {openzc:modules item="shipping"}
                    {openzc:loopson}
                    <div class="content-box__row">
                      <div class="radio-wrapper">
                        <div class="radio__input">
                          <input class="input-radio" type="radio" value="[field:pid/]_[field:id/]" name="shipping" id="checkout_shipping_[field:id/]" {openzc:if $field['status']}checked="checked"{/openzc:if}>
                        </div>
                        <label class="radio__label openzc-btn" data-action="setShipping" data-id="[field:pid/]_[field:id/]" data-reload="orderTotal" for="checkout_shipping_[field:id/]" > <span class="radio__label__primary" > [field:module/] ([field:title/]) </span> <span class="radio__label__accessory"> <span class="content-box__emphasis"> [field:cost/] </span> </span> </label>
                      </div>
                    </div>
                    {/openzc:loopson}
                    {/openzc:modules} </div>
                </div>
              </div>
              <div class="section section--comments">
                <div class="section__header">
                  <h2 class="section__title" id="main-header" tabindex="-1"> Comments </h2>
                </div>
                <div class="section__content">
                  <div class="content-box">
                    <div role="table" class="content-box__row content-box__row--tight-spacing-vertical">
                      <div role="row" class="review-block">
                        <textarea type="text" class="field__textarea" name="comments" id="checkout_comments">{openzc:var name="$_SESSION['comments']"/}</textarea>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="step__footer" data-step-footer="">
              <button type="submit" id="continue_button" class="step__footer__continue-btn btn" aria-busy="false"><span class="btn__content" data-continue-button-content="true">Continue to payment</span> <svg class="icon-svg icon-svg--size-18 btn__spinner icon-svg--spinner-button" aria-hidden="true" focusable="false">
              <use xlink:href="#spinner-button"></use>
              </svg> </button>
              <a class="step__footer__previous-link" href="{openzc:link name='FILENAME_CHECKOUT_INFORMATION'/}"> <svg focusable="false" aria-hidden="true" class="icon-svg icon-svg--color-accent icon-svg--size-10 previous-link__icon" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10">
              <path d="M8 1L7 0 3 4 2 5l1 1 4 4 1-1-4-4"></path>
              </svg> <span class="step__footer__previous-link-content">Return to information</span></a> </div>
          </form>
        </div>
      </main>
      {openzc:include filename="./footer.tpl"/} </div>
    {openzc:include filename="./aside_mobile.tpl"/} </div>
</div>
</body>
{openzc:include filename="./javascript.tpl"/}
</html>