﻿<!DOCTYPE html>
<html lang="en" dir="ltr" class="js windows chrome desktop page--no-banner page--logo-main page--show page--show card-fields cors svg opacity placeholder no-touchevents displaytable display-table generatedcontent cssanimations flexbox no-flexboxtweener anyflexbox no-shopemoji floating-labels" style="">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0, height=device-height, minimum-scale=1.0, user-scalable=0">
<meta name="referrer" content="origin">
<title>{openzc:define.HEADING_TITLE/}</title>
<meta data-browser="chrome" data-browser-major="86">
<meta data-body-font-family="-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol'" data-body-font-type="system">
<link href="/assets/system/css/checkout.css" rel="stylesheet">
</head>
<body>
<header class="banner" role="banner" aria-hidden="false">
  <div class="wrap"> <a class="logo logo--left" href="{openzc:link name='FILENAME_INDEX'/}"><span class="logo__text heading-1">{openzc:define.STORE_NAME/}</span></a> </div>
</header>
<aside role="complementary">
  <button class="order-summary-toggle order-summary-toggle--show" >
	  <span class="wrap">
		  <span class="order-summary-toggle__inner">
			  <span class="order-summary-toggle__icon-wrapper">
				  <svg width="20" height="19" xmlns="http://www.w3.org/2000/svg" class="order-summary-toggle__icon">
					  <path d="M17.178 13.088H5.453c-.454 0-.91-.364-.91-.818L3.727 1.818H0V0h4.544c.455 0 .91.364.91.818l.09 1.272h13.45c.274 0 .547.09.73.364.18.182.27.454.18.727l-1.817 9.18c-.09.455-.455.728-.91.728zM6.27 11.27h10.09l1.454-7.362H5.634l.637 7.362zm.092 7.715c1.004 0 1.818-.813 1.818-1.817s-.814-1.818-1.818-1.818-1.818.814-1.818 1.818.814 1.817 1.818 1.817zm9.18 0c1.004 0 1.817-.813 1.817-1.817s-.814-1.818-1.818-1.818-1.818.814-1.818 1.818.814 1.817 1.818 1.817z"></path>
				  </svg>
			  </span>
			  <span class="order-summary-toggle__text order-summary-toggle__text--show">
				  <span>See order summary</span>
				  <svg width="11" height="6" xmlns="http://www.w3.org/2000/svg" class="order-summary-toggle__dropdown" fill="#000">
					  <path d="M.504 1.813l4.358 3.845.496.438.496-.438 4.642-4.096L9.504.438 4.862 4.534h.992L1.496.69.504 1.812z"></path>
				  </svg>
			  </span>
			  <span class="order-summary-toggle__text order-summary-toggle__text--hide">
				  <span>Hide order summary</span>
				  <svg width="11" height="7" xmlns="http://www.w3.org/2000/svg" class="order-summary-toggle__dropdown" fill="#000">
					  <path d="M6.138.876L5.642.438l-.496.438L.504 4.972l.992 1.124L6.138 2l-.496.436 3.862 3.408.992-1.122L6.138.876z"></path>
				  </svg>
			  </span>
			  <dl class="order-summary-toggle__total-recap total-recap" >
				  <dd>
					  <span class="order-summary__emphasis total-recap__final-price skeleton-while-loading" >
						  {openzc:echo}$currencies->display_price($order->info['total'],'');{/openzc:echo}
				  	  </span>
			      </dd>
			  </dl>
		  </span>
	  </span>
  </button>
</aside>
<div class="content">
  <div class="wrap">
    <div class="main">
      <header class="main__header" role="banner"> <a class="logo logo--left" href="{openzc:define.HTTPS_SERVER/}"><span class="logo__text heading-1">{openzc:define.STORE_NAME/}</span></a>
        <h1 class="visually-hidden"> Thank you for your purchase! </h1>
      </header>
      <main class="main__content" role="main"> 
        <!-- BEGIN template -->
        
        <div class="step" data-step="thank_you">
          <div class="step__sections">
            <div class="section">
              <div class="section__header os-header">
                <svg t="1648020558436" class="icon icon-svg icon-svg--color-accent icon-svg--size-48 os-header__hanging-icon" viewBox="0 0 1025 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="3994" width="48" height="48"><path d="M511.679524 1023.15939c-68.658678 0-135.399619-13.564433-198.369591-40.316509-60.752236-25.809077-115.373446-62.712976-162.346233-109.685763-46.971763-46.971763-83.875662-101.592974-109.685763-162.346233-26.751052-62.969971-40.315485-129.710912-40.315485-198.368567s13.564433-135.399619 40.315485-198.369591c25.810101-60.752236 62.714-115.373446 109.685763-162.346233 46.972787-46.971763 101.593997-83.875662 162.346233-109.685763C376.279905 15.28968 443.020846 1.725247 511.679524 1.725247S647.078119 15.28968 710.048091 42.040731c60.752236 25.810101 115.37447 62.714 162.346233 109.685763 46.972787 46.972787 83.876686 101.593997 109.686787 162.346233 26.752076 62.969971 40.316509 129.710912 40.316509 198.369591s-13.564433 135.398595-40.316509 198.368567c-25.810101 60.75326-62.712976 115.37447-109.685763 162.346233-46.971763 46.972787-101.593997 83.876686-162.346233 109.685763C647.079143 1009.594957 580.337178 1023.15939 511.679524 1023.15939zM511.679524 50.871742c-62.018782 0-122.293887 12.247716-179.152287 36.403219-54.923257 23.333323-104.317532 56.709936-146.810821 99.204249s-75.870926 91.888588-99.204249 146.810821c-24.155503 56.8584-36.403219 117.133505-36.403219 179.152287 0 62.017758 12.247716 122.292863 36.403219 179.152287 23.333323 54.923257 56.709936 104.317532 99.204249 146.811845 42.493289 42.493289 91.888588 75.870926 146.810821 99.204249 56.8584 24.155503 117.133505 36.403219 179.152287 36.403219 62.017758 0 122.293887-12.247716 179.153311-36.403219 54.923257-23.333323 104.317532-56.71096 146.810821-99.204249 42.494313-42.494313 75.87195-91.888588 99.205273-146.811845 24.155503-56.8584 36.403219-117.133505 36.403219-179.152287s-12.247716-122.293887-36.404243-179.152287c-23.333323-54.923257-56.71096-104.317532-99.204249-146.810821-42.494313-42.493289-91.888588-75.870926-146.811845-99.204249C633.972387 63.119459 573.697282 50.871742 511.679524 50.871742z" p-id="3995"></path><path d="M451.780185 689.848881c-6.223175 0-12.452493-2.255619-17.365095-6.794503L253.195578 515.658342c-10.384245-9.592782-11.027245-25.787576-1.434463-36.171821 9.592782-10.386293 25.786552-11.026221 36.171821-1.434463l163.146912 150.703633 289.753404-289.754428c9.997216-9.996192 26.203273-9.996192 36.199466 0 9.996192 9.996192 9.996192 26.203273 0 36.199466L469.883501 682.351993C464.896156 687.339338 458.342266 689.848881 451.780185 689.848881z" p-id="3996"></path></svg>
                <div class="os-header__heading"><h2 class="os-order-number"> Order No.{openzc:var name="$zv_orders_id"/} </h2>
                  <p class="" id="main-header" tabindex="-1"> <b>{openzc:define.HEADING_TITLE/}</b></p>
                </div>
              </div>
            </div>
            <div class="section">
              <div class="section__content">
                <div class="content-box">
                  <div class="content-box__row text-container">
                    <h2 class="heading-2 os-step__title">Your order is confirmed</h2>
                    <div class="os-step__special-description">
                      <p class="os-step__description"> You’ll receive an email when your order is ready. </p>
                      
                    </div>
                    
                  </div>
                </div>
                <div class="content-box">
                  <div class="content-box__row content-box__row--no-border">
                    <h2>Customer information</h2>
                  </div>
                  <div class="content-box__row">
                    <div class="section__content">
                      <div class="section__content__column">
                        <div class="text-container">
                          <h3 class="heading-3">Contact information</h3>
                          <p>
                            <bdo dir="ltr">{openzc:var name="$order->customer['email_address']"/}</bdo>
                          </p>
                        </div>
                      </div>
                      
                    </div>
                  </div>
                  <div class="content-box__row">
                    <div class="section__content">
                      <div class="section__content__column section__content__column--half">
                        <div class="text-container">
                          <h3 class="heading-3">Shipping address</h3>
                          <address class="address">
                          {openzc:echo}zen_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br />');{/openzc:echo}
                          </address>
                        </div>
                      </div>
                      <div class="section__content__column section__content__column--half">
                        <div class="text-container">
                          <h3 class="heading-3">Billing address</h3>
                          <address class="address">
                          {openzc:echo}zen_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br />');{/openzc:echo}
                          </address>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="content-box__row">
                    <div class="section__content">
                      <div class="section__content__column section__content__column--half">
                        <div class="text-container">
                          <h3 class="heading-3">Shipping Method</h3>
                          <p>{openzc:var name="$order->info['shipping_method']"/}</p>
                        </div>
                      </div>
                      <div class="section__content__column section__content__column--half">
                        <div class="text-container">
                          <h3 class="heading-3">Payment Method</h3>
                          <p>{openzc:var name="$order->info['payment_method']"/}</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  {openzc:if $_SESSION['comments']}
                  <div class="content-box__row">
                    <div class="section__content">
                      <div class="section__content__column">
                        <div class="text-container">
                          <h3 class="heading-3">Comments</h3>
                          <p>
                            {openzc:echo}$_SESSION['comments'];{/openzc:echo}
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                  {/openzc:if}
                </div>
              </div>
            </div>
          </div>
          <div class="step__footer"> <a href="{openzc:define.HTTPS_SERVER/}" data-osp-continue-button="" class="step__footer__continue-btn btn"> <span class="btn__content">Continue shopping</span> <svg class="icon-svg icon-svg--size-18 btn__spinner icon-svg--spinner-button" aria-hidden="true" focusable="false">
            <use xlink:href="#spinner-button"></use>
            </svg> </a>
            <p class="step__footer__info"> Need help? <a data-contact-us-link="true" href="mailto:{openzc:define.STORE_OWNER_EMAIL_ADDRESS/}">Contact us</a> </p>
          </div>
        </div>
        <div class="hidden"> <span class="visually-hidden" id="forwarding-external-new-window-message"> Opens external website in a new window. </span> <span class="visually-hidden" id="forwarding-new-window-message"> Opens in a new window. </span> <span class="visually-hidden" id="forwarding-external-message"> Opens external website. </span> <span class="visually-hidden" id="checkout-context-step-one"> Customer information - {openzc:define.STORE_NAME/} - Checkout </span> </div>
        
        <!-- END template --> 
      </main>
      <footer class="main__footer" role="contentinfo">
        <p class="copyright-text "> All rights reserved {openzc:define.STORE_NAME/} </p>
      </footer>
    </div>
    <aside class="sidebar" role="complementary">
      <div class="sidebar__header"> <a class="logo logo--left" href="{openzc:link name='FILENAME_INDEX'/}"><span class="logo__text heading-1">Miss Boon Boutique V��g��tale</span></a>
        <h1 class="visually-hidden"> Client information </h1>
      </div>
      <div class="sidebar__content">
        <div id="order-summary" class="order-summary order-summary--is-collapsed" >
          <h2 class="visually-hidden-if-js">Order summary</h2>
          <div class="order-summary__sections">
            <div class="order-summary__section order-summary__section--product-list">
              <div class="order-summary__section__content">
                <table class="product-table">
                  <caption class="visually-hidden">
                  Cart
                  </caption>
                  <tbody>
                  {openzc:cart flag="order"}
                  <tr class="product">
                    <td class="product__image"><div class="product-thumbnail ">
                        <div class="product-thumbnail__wrapper"> <img alt="[field:products_name/]" class="product-thumbnail__image" src="[field:products_image/]"> </div>
                        <span class="product-thumbnail__quantity" aria-hidden="true">[field:quantity/]</span> </div></td>
                    <th class="product__description" scope="row"> <span class="product__description__name order-summary__emphasis">[field:products_name/]</span> <span class="product__description__variant order-summary__small-text"> {openzc:loopson item="attr"}
                      [field:products_options_name/]:[field:products_options_values_name/]<br/>
                      {/openzc:loopson} </span> </th>
                    <td class="product__quantity"><span class="visually-hidden"> [field:quantity/] </span></td>
                    <td class="product__price"><span class="order-summary__emphasis skeleton-while-loading">[field:final_price/]</span></td>
                  </tr>
                  {/openzc:cart}
                  </tbody>
                </table>
                <div class="order-summary__scroll-indicator" aria-hidden="true"> Scroll to see more products
                  <svg aria-hidden="true" focusable="false" class="icon-svg icon-svg--size-12">
                    <use xlink:href="#down-arrow"></use>
                  </svg>
                </div>
              </div>
            </div>
			
            <div class="order-summary__section order-summary__section--total-lines" >
			  
              <table class="total-line-table">
                <tbody class="total-line-table__tbody">
                {openzc:var name="$order->totals"}
					{openzc:if $field['class']!='ot_total'}
					<tr class="total-line total-line--subtotal">
					  <th class="total-line__name" scope="row">[field:title/]</th>
					  <td class="total-line__price"><span class="order-summary__emphasis skeleton-while-loading" > [field:text/] </span></td>
					</tr>
					{/openzc:if}
                {/openzc:var}
                </tbody>
				{openzc:var name="$order->totals"}
				  {openzc:if $field['class']=='ot_total'}
				  <tfoot class="total-line-table__footer">
					<tr class="total-line">
					  <th class="total-line__name payment-due-label" scope="row"><span class="payment-due-label__total">[field:title/]</span></th>
					  <td class="total-line__price payment-due"><span class="payment-due__price skeleton-while-loading--lg" > [field:text/] </span></td>
					</tr>
				    </tfoot>
				    {/openzc:if}
				{/openzc:var}
              </table>
			</div>
          </div>
        </div>
        <div id="partial-icon-symbols" class="icon-symbols" >
          <svg xmlns="http://www.w3.org/2000/svg">
            <symbol id="ship">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                <path d="M17.816 14c-.415-1.162-1.514-2-2.816-2-1.302 0-2.4.838-2.816 2H12v-4h6v4h-.184zM15 16c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zM5 16c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zM2 4h8v10H7.816C7.4 12.838 6.302 12 5 12c-1.302 0-2.4.838-2.816 2H2V4zm13.434 1l1.8 3H12V5h3.434zm4.424 3.485l-3-5C16.678 3.185 16.35 3 16 3h-4c0-.552-.448-1-1-1H1c-.552 0-1 .448-1 1v12c0 .552.448 1 1 1h1.185C2.6 17.162 3.698 18 5 18s2.4-.838 2.816-2h4.37c.413 1.162 1.512 2 2.814 2s2.4-.838 2.816-2H19c.552 0 1-.448 1-1V9c0-.18-.05-.36-.142-.515z" fill-rule="evenodd"></path>
              </svg>
            </symbol>
            <symbol id="pickup">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18">
                <path d="M14.6 16H3.4c-.442 0-.8-.358-.8-.8V7.554C1.648 7 1 5.98 1 4.8V4c0-.12.032-.232.08-.336L2.684.442C2.82.172 3.096 0 3.4 0h11.2c.304 0 .58.17.716.442 0 0 1.602 3.214 1.604 3.222.048.104.08.216.08.336v.8c0 1.18-.648 2.2-1.6 2.754V15.2c0 .442-.358.8-.8.8zm-.8-9.6c.882 0 1.6-.718 1.6-1.6h-3.2c0 .882.718 1.6 1.6 1.6zm0 8V8c-.954 0-1.814-.42-2.4-1.086C10.814 7.58 9.954 8 9 8s-1.814-.42-2.4-1.086C6.014 7.58 5.154 8 4.2 8v6.4h1.6v-4c0-.442.358-.8.8-.8h4.8c.442 0 .8.358.8.8v4h1.6zM2.6 4.8c0 .882.718 1.6 1.6 1.6.882 0 1.6-.718 1.6-1.6H2.6zm8 0H7.4c0 .882.718 1.6 1.6 1.6.882 0 1.6-.718 1.6-1.6zM3.894 1.6l-.8 1.6h11.812l-.8-1.6H3.894zM7.4 14.4h3.2v-3.2H7.4v3.2z"></path>
              </svg>
            </symbol>
            <symbol id="info">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M12 11h1v7h-2v-5c-.552 0-1-.448-1-1s.448-1 1-1h1zm0 13C5.373 24 0 18.627 0 12S5.373 0 12 0s12 5.373 12 12-5.373 12-12 12zm0-2c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10zM10.5 7.5c0-.828.666-1.5 1.5-1.5.828 0 1.5.666 1.5 1.5 0 .828-.666 1.5-1.5 1.5-.828 0-1.5-.666-1.5-1.5z"></path>
              </svg>
            </symbol>
            <symbol id="caret-down">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10">
                <path d="M0 3h10L5 8" fill-rule="nonzero"></path>
              </svg>
            </symbol>
            <symbol id="question">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
                <path d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm.7 13H6.8v-2h1.9v2zm2.6-7.1c0 1.8-1.3 2.6-2.8 2.8l-.1 1.1H7.3L7 7.5l.1-.1c1.8-.1 2.6-.6 2.6-1.6 0-.8-.6-1.3-1.6-1.3-.9 0-1.6.4-2.3 1.1L4.7 4.5c.8-.9 1.9-1.6 3.4-1.6 1.9.1 3.2 1.2 3.2 3z"></path>
              </svg>
            </symbol>
            <symbol id="close">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
                <path d="M15.1 2.3L13.7.9 8 6.6 2.3.9.9 2.3 6.6 8 .9 13.7l1.4 1.4L8 9.4l5.7 5.7 1.4-1.4L9.4 8"></path>
              </svg>
            </symbol>
            <symbol id="spinner-small">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
                <path d="M32 16c0 8.837-7.163 16-16 16S0 24.837 0 16 7.163 0 16 0v2C8.268 2 2 8.268 2 16s6.268 14 14 14 14-6.268 14-14h2z"></path>
              </svg>
            </symbol>
            <symbol id="spinner-button">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                <path d="M20 10c0 5.523-4.477 10-10 10S0 15.523 0 10 4.477 0 10 0v2c-4.418 0-8 3.582-8 8s3.582 8 8 8 8-3.582 8-8h2z"></path>
              </svg>
            </symbol>
            <symbol id="chevron-right">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10">
                <path d="M2 1l1-1 4 4 1 1-1 1-4 4-1-1 4-4"></path>
              </svg>
            </symbol>
            <symbol id="down-arrow">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 12 12">
                <path d="M10.817 7.624l-4.375 4.2c-.245.235-.64.235-.884 0l-4.375-4.2c-.244-.234-.244-.614 0-.848.245-.235.64-.235.884 0L5.375 9.95V.6c0-.332.28-.6.625-.6s.625.268.625.6v9.35l3.308-3.174c.122-.117.282-.176.442-.176.16 0 .32.06.442.176.244.234.244.614 0 .848"></path>
              </svg>
            </symbol>
            <symbol id="arrow">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
                <path d="M16 8.1l-8.1 8.1-1.1-1.1L13 8.9H0V7.3h13L6.8 1.1 7.9 0 16 8.1z"></path>
              </svg>
            </symbol>
            <symbol id="mobile-phone">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M5 2.99C5 1.34 6.342 0 8.003 0h7.994C17.655 0 19 1.342 19 2.99v18.02c0 1.65-1.342 2.99-3.003 2.99H8.003C6.345 24 5 22.658 5 21.01V2.99zM7 5c0-.552.456-1 .995-1h8.01c.55 0 .995.445.995 1v14c0 .552-.456 1-.995 1h-8.01C7.445 20 7 19.555 7 19V5zm5 18c.552 0 1-.448 1-1s-.448-1-1-1-1 .448-1 1 .448 1 1 1z" fill-rule="evenodd"></path>
              </svg>
            </symbol>
            <symbol id="lock">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14 14">
                <path d="M12 6h-1V4c0-2.2-1.8-4-4-4S3 1.8 3 4v2H2c-.5 0-1 .5-1 1v6c0 .5.5 1 1 1h10c.5 0 1-.5 1-1V7c0-.5-.5-1-1-1zM5 4c0-1.1.9-2 2-2s2 .9 2 2v2H5V4z"></path>
              </svg>
            </symbol>
          </svg>
        </div>
      </div>
    </aside>
    </div>
</div>
</body>
{openzc:include filename="./javascript.tpl"/}
</html>