﻿<!DOCTYPE html>
<html lang="en-US">
<head>

<!-- Meta============================================= -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, intial-scale=1, max-scale=1">
<meta name="author" content="OpenzcTPL.">
<title>{openzc:define.META_TAG_TITLE/}</title>
<meta name="keywords" content="{openzc:define.META_TAG_KEYWORDS/}" />
<meta name="description" content="{openzc:define.META_TAG_DESCRIPTION/}" />
<!-- Stylesheets============================================= -->
{openzc:include filename="common/css.tpl"/}
<!-- Favicon============================================= -->
{openzc:include filename="common/favicon.tpl"/}
</head>

<body>

<!-- Document Full Container
	============================================= -->
<div id="full-container"> 
  
  <!-- Header
		============================================= -->
  {openzc:include filename="common/header.tpl"/}
  <!-- #header end --> 
  
  <!-- Content
		============================================= -->
  <section id="content">
    <div id="content-wrap"> 
      
      <!-- Page Title
				============================================= -->
      <div id="page-title">
        <div id="page-title-wrap">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <ul class="breadcrumb">
                  {openzc:field.position/}
                </ul>
                <!-- .breadcrumb end --> 
                
              </div>
              <!-- .col-md-12 end --> 
            </div>
            <!-- .row end --> 
          </div>
          <!-- .container end --> 
          
        </div>
        <!-- #page-title-wrap end --> 
        
      </div>
      <!-- #page-title end --> 
      
      <!-- === Content Main =========== -->
      <div id="content-main" class="section-flat page-single page-product-comparison">
        <div class="section-content">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <div class="page-single-content">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="content">
                        <div class="block-content">
						{openzc:ajax filename="comparelist"}
						  {openzc:if $compareCount>0}
                          <h5 class="block-title">Products Comparison <span>( {openzc:var name='$compareCount'/} )</span></h5>
                          <div class="row">
                            <div class="col-md-12">
                              <div id="table-products-comparison">
                                <table>
                                  <thead>
                                    <tr>
                                      <th>Product Name</th>
									  {openzc:prolist type="compare"}
                                      <th>[field:products_name/]</th>
									  {/openzc:prolist}
                                    </tr>
                                  </thead>
                                  <tbody>
                                    <tr>
                                      <td>Product Image</td>
									  {openzc:prolist type="compare" imgsizer=""}
                                      <td><a href="[field:products_link/]"><img src="[field:products_image/]" alt=""></a></td>
									  {/openzc:prolist}
                                    </tr>
                                    <tr>
                                      <td>Price</td>
									  {openzc:prolist type="compare"}
                                      <td>[field:products_price/]</td>
									  {/openzc:prolist}
                                    </tr>
								    {openzc:proattr type="compare"}
									<tr>
										<td>
											[field:options_name/]
										</td>
										{openzc:prolist type="compare"}
										<td>
											{openzc:proattr}
											{openzc:loopson}[field:options_values_name/]、{/openzc:loopson}
											{/openzc:proattr}
										</td>
										{/openzc:prolist}
									</tr>	
									{/openzc:proattr}
                                    <tr>
                                      <td>Quantity</td>
									  {openzc:prolist type="compare"}
                                      <td>Available <span class="color-green">( [field:products_quantity/] Items )</span></td>
									  {/openzc:prolist}
                                    </tr>
                                    <tr>
                                      <td>Rating</td>
									  {openzc:prolist type="compare"}
                                      <td><div class="rating"> {openzc:rating star='<i class="fa fa-star"></i>' empty='<i class="fa fa-star-o"></i>'/}</div>
                                        <!-- .rating end --></td>
									  {/openzc:prolist}
                                    </tr>
                                    <tr>
                                      <td>Description</td>
									  {openzc:prolist type="compare" desclen="120"}
                                      <td>[field:products_description_preview/]...</td>
									  {/openzc:prolist}
                                    </tr>
                                    <tr>
                                      <td>&nbsp;</td>
									  {openzc:prolist type="compare" desclen="120"}
                                      <td>
										  <a class="btn small rounded with-icon colorful hover-colorful-2" href="[field:products_link/]"> <i class="fa fa-shopping-cart"></i> Add to Cart </a>
										  <a class="item-delete openzc-btn" href="javascript:;" data-action="delCompare" data-id="[field:products_id/]" data-reload="comparelist"><i class="fa fa-trash-alt"></i></a></td>
									  {/openzc:prolist}
                                    </tr>
                                  </tbody>
                                </table>
                              </div>
                              <!-- #table-products-comparison end --> 
                              
                            </div>
                            <!-- .col-md-12 end --> 
                          </div>
                          <!-- .row end -->
						  {else}
							empty!
						  {/openzc:if}
						  {/openzc:ajax}
                        </div>
                        <!-- .block-content end --> 
                      </div>
                      <!-- .content end --> 
                      
                    </div>
                    <!-- .col-md-12 end --> 
                  </div>
                  <!-- .row end --> 
                  
                </div>
                <!-- .page-single-content end --> 
                
              </div>
              <!-- .col-md-12 end --> 
            </div>
            <!-- .row end --> 
          </div>
          <!-- .container end --> 
          
        </div>
        <!-- .section-content end --> 
        
      </div>
      <!-- .section-flat end --> 
      
    </div>
    <!-- #content-wrap --> 
    
  </section>
  <!-- #content end --> 
  
  <!-- Footer
		============================================= -->
  <footer id="footer">
    {openzc:include filename="common/newsletters.tpl"/}
    {openzc:include filename="common/footer.tpl"/}
  </footer>
  <!-- #footer end -->
  
  <div class="side-full-categories">
    <div class="mobile-full-categories">
      <h5>All Categories</h5>
      <ul class="mobile-menu-categories">
      </ul>
      <!-- .mobile-menu-categories end --> 
    </div>
    <!-- .mobile-full-categories end --> 
  </div>
  <!-- .side-full-categories end -->
  
  <div class="box-notification"> <i class="fa fa-cart-arrow-down"></i>
    <div class="box-content"> <span>Added to Cart</span>
      <h5>Elitebook 2019</h5>
      <a class="btn x-small grey hover-colorful" href="javascript:;">Shop Cart</a> </div>
    <!-- .box-content end --> 
    <a class="close" href="javascript:;">×</a> </div>
  <!-- .box-notification end --> 
  
</div>
<!-- #full-container end --> 

<a class="scroll-top-icon scroll-top" href="javascript:;"><i class="fa fa-angle-up"></i></a> 

<!-- External JavaScripts
	============================================= --> 
{openzc:include filename="common/script.tpl"/}
</body>
</html>
