<div id="globalcss">
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>{openzc:define.HEADING_TITLE/}</title>
{openzc:include filename="system/common/css.tpl"/}
</head>
<body>
<div class="container mb-5">
  <div class="block-title subtitle is-4 is-spaced mt-6 px-5 is-hidden-mobile"> {openzc:if isset($_GET['delete'])}
    {openzc:define.HEADING_TITLE_DELETE_ENTRY/}
    {else}
    {openzc:define.HEADING_TITLE/}
    {/openzc:if} </div>
  <div class="columns mx-0"> {openzc:include filename="system/account/account_nav.tpl"/}
    <div class="column ">
      <article class="message is-light">
        <div class="message-header">
          <p>{openzc:define.HEADING_TITLE/}</p>
        </div>
        <div class="message-body px-4"> {openzc:if isset($_GET['delete'])}
          <div class="notification is-danger is-light"> {openzc:define.DELETE_ADDRESS_DESCRIPTION/} </div>
          <p class="subtitle is-6"> {openzc:echo}zen_address_label($_SESSION['customer_id'], $_GET['delete'], true, ' ', '<br />
            ');{/openzc:echo} </p>
          <form name="delete_address" action="{openzc:link name='FILENAME_ADDRESS_BOOK_PROCESS' parameter='[action=>deleteconfirm]'/}" method="post">
            <input type="hidden" name="securityToken" value="{openzc:field.securityToken/}">
            <input type="hidden" name="delete" value="{openzc:var name='$_GET[delete]'/}"/>
            <button type="submit" class="button mt-3"><i class="far fa-trash-alt"></i>&nbsp;&nbsp;{openzc:define.BUTTON_DELETE_ALT/}</button>
            <a href="{openzc:link name='FILENAME_BACK'/}" class="button mt-3"><i class="fas fa-reply"></i>&nbsp;&nbsp;{openzc:define.BUTTON_BACK_ALT/}</a>
          </form>
          {else}
          
          {openzc:msg name="addressbook"/}
          {openzc:if isset($_GET['edit'])}
          <form action="{openzc:link name='FILENAME_ADDRESS_BOOK_PROCESS' parameter='[edit=>__edit__]'/}" method="post">
          {else}
          <form action="{openzc:link name='FILENAME_ADDRESS_BOOK_PROCESS'/}" method="post">
            {/openzc:if}
            <input type="hidden" name="securityToken" value="{openzc:field.securityToken/}">
            {openzc:if isset($_GET['edit'])}
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="edit" value="{openzc:var name='$_GET[edit]'/}">
            {else}
            <input type="hidden" name="action" value="process">
            {/openzc:if}
            {openzc:if ACCOUNT_GENDER=='true'}
            <div class="field">
              <label class="label">{openzc:define.ENTRY_GENDER/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_GENDER_TEXT/}</span></label>
              <div class="control">
                <label class="radio">
                  <input type="radio" name="gender" value="m" {openzc:if $address_book['entry_gender']=='m'}checked=""{/openzc:if}>
                  {openzc:define.MALE/} </label>
                <label class="radio">
                  <input type="radio" name="gender" value="f" {openzc:if $address_book['entry_gender']=='f'}checked=""{/openzc:if}>
                  {openzc:define.FEMALE/} </label>
              </div>
            </div>
            {/openzc:if}
            <div class="columns mb-0">
              <div class="field column mb-0">
                <label class="label">{openzc:define.ENTRY_FIRST_NAME/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_FIRST_NAME_TEXT/}</span></label>
                <div class="control">
                  <input class="input" type="text" name="firstname" placeholder="{openzc:define.ENTRY_FIRST_NAME/}" value="{openzc:account field='customers_firstname'/}">
                </div>
              </div>
              <div class="field column mb-0">
                <label class="label">{openzc:define.ENTRY_LAST_NAME/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_LAST_NAME_TEXT/}</span></label>
                <div class="control">
                  <input class="input" type="text" name="lastname" placeholder="{openzc:define.ENTRY_LAST_NAME/}" value="{openzc:account field='customers_lastname'/}">
                </div>
              </div>
            </div>
            {openzc:if ACCOUNT_COMPANY == 'true'}
            
            {/openzc:if}
            <div class="field">
              <label class="label">{openzc:define.ENTRY_STREET_ADDRESS/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_STREET_ADDRESS_TEXT/}</span></label>
              <div class="control">
                <input class="input" type="text" name="street_address" placeholder="{openzc:define.ENTRY_STREET_ADDRESS/} {openzc:define.ENTRY_STREET_ADDRESS_TEXT/}" value="{openzc:account item='address' field='street_address'/}">
              </div>
            </div>
            {openzc:if ACCOUNT_SUBURB == 'true'}
            <div class="field">
              <label class="label">{openzc:define.ENTRY_SUBURB/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_SUBURB_TEXT/}</span></label>
              <div class="control">
                <input class="input" type="text" name="suburb" placeholder="{openzc:define.ENTRY_SUBURB/} {openzc:define.ENTRY_SUBURB_TEXT/}" value="{openzc:account item='address' field='entry_suburb'/}">
              </div>
            </div>
            {/openzc:if}
            <div class="field">
              <label class="label">{openzc:define.ENTRY_CITY/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_CITY_TEXT/}</span></label>
              <div class="control">
                <input class="input" type="text" name="city" placeholder="{openzc:define.ENTRY_CITY/} {openzc:define.ENTRY_CITY_TEXT/}" value="{openzc:account item='address' field='entry_city'/}">
              </div>
            </div>
            <div class="columns">
              <div class="field column mb-0">
                <label class="label">{openzc:define.ENTRY_COUNTRY/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_COUNTRY_TEXT/}</span></label>
                <div class="control">
                  <div class="select is-fullwidth ">
                    <select name="zone_country_id" class="openzc-select" data-action="getState" data-reload="address_book_state">
                      
							  {openzc:var name="$countries"}
								
                      <option value="[field:id/]" {openzc:if $field['status']=="active"}selected=""{/openzc:if}>[field:text/]</option>
                      
							  {/openzc:var}
						  
                    </select>
                  </div>
                </div>
              </div>
              <div class="field column mb-0"> {openzc:ajax filename="address_book_state"}
				
                {openzc:if ACCOUNT_STATE == 'true'}
                {openzc:if count($GLOBALS['states'])>1}
                <label class="label">{openzc:define.ENTRY_STATE/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_STATE_TEXT/}</span></label>
                <div class="control">
                  <div class="select is-fullwidth {openzc:if isset($create_account_error['state'])}is-danger{/openzc:if}">
                    <select name="zone_id">
					{openzc:var name="$GLOBALS['states']"}
                      <option value="[field:id/]" {openzc:if $field['status']=="active"}selected=""{/openzc:if}>[field:text/]</option>
					{/openzc:var}
                    </select>
                  </div>
                </div>
                <input type="hidden" name="state" value="{openzc:account item='address' field='state'/}">
                {else}
                <label class="label">{openzc:define.ENTRY_STATE/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_STATE_TEXT/}</span></label>
                <div class="control">
                  <input class="input {openzc:if isset($create_account_error['state'])}is-danger{/openzc:if}" type="text" name="state" placeholder="{openzc:define.ENTRY_STATE/} {openzc:define.ENTRY_STATE_TEXT/}" value="{openzc:if $zone_name}{openzc:var name='$zone_name'/}{/openzc:if}">
                </div>
                <input type="hidden" name="zone_id" value="{openzc:if $zone_name}{openzc:var name='$zone_name'/}{/openzc:if}"/>
                {/openzc:if}
                
                {/openzc:if}
                {/openzc:ajax} </div>
              <div class="field column mb-0">
                <label class="label">{openzc:define.ENTRY_POST_CODE/} <span class="has-text-danger subtitle is-6">{openzc:define.ENTRY_POST_CODE_TEXT/}</span></label>
                <div class="control">
                  <input class="input {openzc:if isset($create_account_error['postcode'])}is-danger{/openzc:if}" type="text" name="postcode" placeholder="{openzc:define.ENTRY_POST_CODE/} {openzc:define.ENTRY_POST_CODE_TEXT/}" value="{openzc:account field='customers_postcode'/}">
                </div>
              </div>
            </div>
            {openzc:if $address_book['primary']==false}
            <div class="field">
              <div class="control">
                <label class="checkbox">
                  <input type="checkbox" name="primary" value="on" >
                  {openzc:define.SET_AS_PRIMARY/} </label>
              </div>
            </div>
            {/openzc:if}
            <input type="hidden" name="submitAddress" value="1">
            <div class="field level is-mobile mt-5">
              <div class="control level-left">
                <button class="button is-link is-outlined"><i class="far fa-check-circle"></i>&nbsp;&nbsp;{openzc:define.BUTTON_SUBMIT_ALT/}</button>
              </div>
              <p class="level-right"><a class="button " href="{openzc:link name='FILENAME_ACCOUNT'/}"><i class="fas fa-reply"></i>&nbsp;&nbsp;{openzc:define.BUTTON_BACK_ALT/}</a></p>
            </div>
          </form>
          {/openzc:if} </div>
      </article>
    </div>
  </div>
</div>
</body>
{openzc:include filename="system/common/js.tpl"/}
</html>
</div>