﻿<!DOCTYPE html>
<html lang="en-US">
<head>

<!-- Meta============================================= -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, intial-scale=1, max-scale=1">
<meta name="author" content="OpenzcTPL.">
<title>{openzc:define.META_TAG_TITLE/}</title>
<meta name="keywords" content="{openzc:define.META_TAG_KEYWORDS/}" />
<meta name="description" content="{openzc:define.META_TAG_DESCRIPTION/}" />
<!-- Stylesheets============================================= -->
{openzc:include filename="common/css.tpl"/}
<!-- Favicon============================================= -->
{openzc:include filename="common/favicon.tpl"/}
</head>

<body>

<!-- Document Full Container
	============================================= -->
<div id="full-container"> 
  
  <!-- Header============================================= -->
  {openzc:include filename="common/header.tpl"/}
  <!-- #header end --> 
  
  <!-- Content
		============================================= -->
  <section id="content">
    <div id="content-wrap"> 
      
      <!-- Page Title
				============================================= -->
      <div id="page-title">
        <div id="page-title-wrap">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <ul class="breadcrumb">
                  <li><a href="index.html"><i class="fa fa-home"></i>Home</a></li>
                  <li class="active">Shop Cart</li>
                </ul>
                <!-- .breadcrumb end --> 
                
              </div>
              <!-- .col-md-12 end --> 
            </div>
            <!-- .row end --> 
          </div>
          <!-- .container end --> 
          
        </div>
        <!-- #page-title-wrap end --> 
        
      </div>
      <!-- #page-title end --> 
      
      <!-- === Content Main =========== -->
      <div id="content-main" class="section-flat page-single page-shop-cart">
        <div class="section-content">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <div class="page-single-content">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="content">
                        <div class="block-content">
							{openzc:ajax filename="wishlist"}
							{openzc:if $wishlistCount>0}
                          <h5 class="block-title">Wishlist <span>( {openzc:var name="$wishlistCount"/} )</span></h5>
						  
					
                          <div class="row">
                            <div class="col-md-12">
                              <div id="table-wishlist">
                                <table>
                                  <thead>
                                    <tr>
                                      <th>Product Image</th>
                                      <th>Product Name</th>
                                      <th>Product State</th>
                                      <th>Quantity</th>
                                      <th>Price</th>
                                    </tr>
                                  </thead>
                                  <tbody>
									{openzc:prolist type="wishlist"}
                                    <tr>
                                      <td><a href="javascript:;"><img src="[field:products_image/]" alt=""></a></td>
                                      <td><ul class="cart-item">
                                          <li><a href="[field:categories_link/]">[field:categories_name/]</a></li>
                                          <li>
                                            <h5><a href="[field:products_link/]">[field:products_name/]</a></h5>
                                          </li>
                                        </ul>
                                        <!-- .cart-item end --></td>
                                      <td><h6>Available</h6></td>
                                      <td><h6>[field:products_price/]</h6></td>
                                      <td><a class="btn btn-add-to-cart small rounded with-icon colorful hover-colorful-2" href="[field:products_link/]"> <i class="fa fa-shopping-cart"></i> Add to Cart </a> <a class="item-delete openzc-btn" data-action="delWishlist" data-id="[field:products_id/]" data-reload="wishlist" href="javascript:;"><i class="fa fa-trash-alt"></i></a></td>
                                    </tr>
									{/openzc:prolist}
                                  </tbody>
                                </table>
                              </div>
                              <!-- #table-wishlist end -->
                              <div class="table-btns"> <a class="btn medium colorful hover-grey" href="{openzc:link name='FILENAME_INDEX'/}">Continue Shopping</a> </div>
                              <!-- .table-btns end --> 
                              
                            </div>
                            <!-- .col-md-12 end --> 
                          </div>
						
                          <!-- .row end --> 
                        </div>
						  {else}
						  empty!
						  {/openzc:if}
						  
						  	{/openzc:ajax}
                        <!-- .block-content end --> 
                      </div>
                      <!-- .content end --> 
                      
                    </div>
                    <!-- .col-md-12 end --> 
                  </div>
                  <!-- .row end --> 
                  
                </div>
                <!-- .page-single-content end --> 
                
              </div>
              <!-- .col-md-12 end --> 
            </div>
            <!-- .row end --> 
          </div>
          <!-- .container end --> 
          
        </div>
        <!-- .section-content end --> 
        
      </div>
      <!-- .section-flat end --> 
      
    </div>
    <!-- #content-wrap --> 
    
  </section>
  <!-- #content end --> 
  
  <!-- Footer
		============================================= -->
  <footer id="footer">
    {openzc:include filename="common/newsletters.tpl"/}
    {openzc:include filename="common/footer.tpl"/}
  </footer>
  <!-- #footer end -->
  
  <div class="side-full-categories">
    <div class="mobile-full-categories">
      <h5>All Categories</h5>
      <ul class="mobile-menu-categories">
      </ul>
      <!-- .mobile-menu-categories end --> 
    </div>
    <!-- .mobile-full-categories end --> 
  </div>
  <!-- .side-full-categories end -->
  
  <div class="box-notification"> <i class="fa fa-cart-arrow-down"></i>
    <div class="box-content"> <span>Added to Cart</span>
      <h5>Elitebook 2019</h5>
      <a class="btn x-small grey hover-colorful" href="javascript:;">Shop Cart</a> </div>
    <!-- .box-content end --> 
    <a class="close" href="javascript:;">×</a> </div>
  <!-- .box-notification end --> 
  
</div>
<!-- #full-container end --> 

<a class="scroll-top-icon scroll-top" href="javascript:;"><i class="fa fa-angle-up"></i></a> 

<!-- External JavaScripts============================================= --> 
{openzc:include filename="common/script.tpl"/}
</body>
</html>
