<?php
/**
 * @link         http://www.openzc.cn/
 * @author       hexipeng | e-mail:2017412656@qq.com
 * @copyright    Copyright (c) 2020, Openzc, Inc.
 * @license      http://www.openzc.cn/license.txt
 */
class rewrite {

	public $canonical = null;

    protected $languages_id;
	
	function __construct($languages_id = ''){
		if ($languages_id == '') {
            $languages_id = $_SESSION['languages_id'];
        }
        $this->languages_id = (int)$languages_id;
        //define("REWRITE_ENABLED",'true');
        //define("REWRITE_STYLE",'opencart');
        //echo $this->href_link("index","cPath=2");exit;
    }

	public function href_link($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true, $static = false, $use_dir_ws_catalog = true) {

		if (!defined('REWRITE_ENABLED') || REWRITE_ENABLED == 'false') {
            return zen_href_link($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true, $static = false, $use_dir_ws_catalog = true);
        }
        $parse_parameters=$this->parse_parameters($_GET['main_page'],$parameters);
        switch(REWRITE_STYLE){
        	case "wordpress":
        	break;
        	case "magento":
        	break;
        	case "opencart":
        	break;
        	case "shopify":
        	break;
        	case "Prestashop":
        	break;
        }
	}

	protected function parse_parameters($page, $params,&$separator="") 
    {

        // -----
        // Strip any leading 'amp;' and change any '&amp;' to '&'.
        //
        if (strpos($params, 'amp;') === 0) {
            $params = substr($params, 4);
        }
        $params = str_replace('&amp;', '&', $params);
        
        // We always need cPath to be first, so find and extract
        $cPath = false;
        if (1 === preg_match('/(?:^|&)c[Pp]ath=([^&]+)/', $params, $path)) {
            $params = str_replace($path[0], '', $params);
            $cPath = $path[1];
        }

        // Cleanup parameters and convert to initial array
        $params = trim($params, "?& \t\n\r\0\x0B");
        $p = array();
        if (!empty($params) && is_string($params)) {
            $p = explode('&', $params);
        }

        // Add the cPath to the start of the parameters if present
        if ($cPath !== false) {
            array_unshift($p, 'cPath=' . $cPath);
        }
        print_r($p);exit;
        $link_params = array();
        foreach ($p as $valuepair) {
            // -----
            // No '=' separating the key from its value?  Set it, so that the array has at least
            // two elements.
            //
            if (strpos($valuepair, '=') === false) {
                $p2 = array($valuepair, '');
            } else {
                $p2 = explode('=', $valuepair);
            }

            // -----
            // Determine if the to-be-generated URL is for one of the 'encoded' pages.
            //
            switch ($p2[0]) {
                // -----
                // If the 'products_id' variable is present, it could be for a product's details page or
                // a product's reviews listing or detailed review.
                //
                case 'products_id':
                    // -----
                    // Make sure if uprid is passed it is converted to the correct pid
                    //
                    $prid = (int)zen_get_prid($p2[1]);
                    
                    // -----
                    // If a cPath was supplied for the link, grab the immediate parent 'category'.
                    //
                    $cID = null;
                    if ($cPath !== false) {
                        $cID = strrpos($cPath, '_');
                        if ($cID !== false) {
                            $cID = substr($cPath, $cID + 1);
                        } else {
                            $cID = $cPath;
                        }
                    }
                    
                    // -----
                    // Now, check for various pages whose URLs are encoded by USU.
                    //
                    $url_created = true;
                    switch (true) {
                        // -----
                        // A product's details' page, e.g. product_info.
                        //
                        case ($page == $this->getInfoPage($prid)):
                            $url = $this->make_url($page, $this->get_product_name($prid, $cID), $p2[0], $prid, USU_END);
                            
                            // -----
                            // Note: The (string) cast is needed, otherwise the (now integer) $prid will be a match
                            // to its uprid (if supplied)!
                            //
                            if (((string)$prid) != $p2[1]) {
                                $link_params[] = $valuepair;
                            }
                            break;

                        // -----
                        // A listing of a product's reviews.
                        //
                        case ($page == FILENAME_PRODUCT_REVIEWS):
                            $url = $this->make_url($page, $this->get_product_name($prid, $cID), 'products_id_review', $prid, USU_END);
                            break;

                        // -----
                        // The display of a product's review details.
                        //
                        case ($page == FILENAME_PRODUCT_REVIEWS_INFO):
                            $url = $this->make_url($page, $this->get_product_name($prid, $cID), 'products_id_review_info', $prid, USU_END);
                            break;

                        // -----
                        // Anything else, just add the parameter to the link's parameters.
                        //
                        default:
                            $url_created = false;
                            $link_params[] = $valuepair;
                            break;
                    }
                    
                    // -----
                    // If a product-specific URL was created and the store's configuration indicates that no cPath parameter should
                    // be included, remove it from the current link parameters.
                    //
                    if ($url_created && $cPath !== false && (USU_CATEGORY_DIR != 'off' || USU_CPATH != 'auto')) {
                        unset($link_params[0]);
                    }
                    break;

                // -----
                // A 'cPath' parameter is normally included on listing pages (for the categories' listings).
                //
                case 'cPath':
                    switch (true) {
                        case ($p2[1] == ''):
                            // Do nothing if cPath is empty
                            break;

                        case ($page == FILENAME_DEFAULT):
                            // Change $p2[1] to the actual category id
                            $tmp = strrpos($p2[1], '_');
                            if ($tmp !== false) {
                                $p2[1] = substr($p2[1], $tmp+1);
                            }

                            $category = $this->get_category_name($p2[1]);
                            if (USU_CATEGORY_DIR == 'off') {
                                $url = $this->make_url($page, $category, $p2[0], $p2[1], USU_END);
                            } else {
                                $url = $this->make_url($page, $category, $p2[0], $p2[1], '/');
                            }
                            unset($category);
                            break;

                        default:
                            $link_params[] = $valuepair;
                            break;
                    }
                    break;

                case 'manufacturers_id':
                    switch (true) {
                        case ($page == FILENAME_DEFAULT && !$this->is_cPath_string($params) && !$this->is_product_string($params)):
                            $url = $this->make_url($page, $this->get_manufacturer_name($p2[1]), $p2[0], $p2[1], USU_END);
                            break;

                        // -----
                        // If the current 'page' requested is a 'product_[something_]info', don't add the parameter.
                        //
                        case (preg_match('/product_(\S+_)?info/', $page)):
                            break;

                        default:
                            $link_params[] = $valuepair;
                            break;
                    }
                    break;

                case 'pID':
                    switch (true) {
                        case ($page == FILENAME_POPUP_IMAGE):
                            $url = $this->make_url($page, $this->get_product_name($p2[1]), $p2[0], $p2[1], USU_END);
                            break;

                        default:
                            $link_params[] = $valuepair;
                            break;
                    }
                    break;

                case 'id':    // EZ-Pages
                    switch (true) {
                        case ($page == FILENAME_EZPAGES):
                            $url = $this->make_url($page, $this->get_ezpages_name($p2[1]), $p2[0], $p2[1], USU_END);
                            break;

                        default:
                            $link_params[] = $valuepair;
                            break;
                    }
                    break;

                default:
                    $link_params[] = $valuepair;
                    break;
            }
        }

        $url = isset($url) ? $url : $page . USU_END;
        if (!empty($link_params)) {
            $url .= $separator . zen_output_string(implode('&', $link_params));
            $separator = '&';
        }

        return $url;
    }

    protected function make_url($page, $link, $anchor_type, $id, $extension = USU_END)
    {
        // In the future there may be additional methods here in the switch
        switch (USU_ENGINE){
            case 'rewrite':
                return $link . $this->reg_anchors[$anchor_type] . $id . $extension;
                break;
            default:
                break;
        }
    }




}
?>