<?php
$process = true;
  $antiSpam = isset($_POST['should_be_empty']) ? zen_db_prepare_input($_POST['should_be_empty']) : '';
  $zco_notifier->notify('NOTIFY_CREATE_ACCOUNT_CAPTCHA_CHECK');

  if (ACCOUNT_GENDER == 'true') {
    if (isset($_POST['gender'])) {
      $gender = zen_db_prepare_input($_POST['gender']);
    } else {
      $gender = false;
    }
  }

  if (isset($_POST['email_format'])) {
    $email_format = zen_db_prepare_input($_POST['email_format']);
  }

  if (ACCOUNT_COMPANY == 'true') $company = zen_db_prepare_input($_POST['company']);
  $firstname = zen_db_prepare_input(zen_sanitize_string($_POST['firstname']));
  $lastname = zen_db_prepare_input(zen_sanitize_string($_POST['lastname']));
  $nick = zen_db_prepare_input($_POST['nick']);
  if (ACCOUNT_DOB == 'true') $dob = zen_db_prepare_input($_POST['dob']);
  $email_address = zen_db_prepare_input($_POST['email_address']);
  $street_address = zen_db_prepare_input($_POST['street_address']);
  if (ACCOUNT_SUBURB == 'true') $suburb = zen_db_prepare_input($_POST['suburb']);
  $postcode = zen_db_prepare_input($_POST['postcode']);
  $city = zen_db_prepare_input($_POST['city']);
  if (ACCOUNT_STATE == 'true') {
    $state = zen_db_prepare_input($_POST['state']);
    if (isset($_POST['zone_id'])) {
      $zone_id = zen_db_prepare_input($_POST['zone_id']);
    } else {
      $zone_id = false;
    }
  }
  $country = zen_db_prepare_input($_POST['zone_country_id']);
  $telephone = zen_db_prepare_input($_POST['telephone']);
  $fax = zen_db_prepare_input($_POST['fax']);
  $customers_authorization = (int)CUSTOMERS_APPROVAL_AUTHORIZATION;
  $customers_referral = zen_db_prepare_input($_POST['customers_referral']);

  if (ACCOUNT_NEWSLETTER_STATUS == '1' || ACCOUNT_NEWSLETTER_STATUS == '2') {
    $newsletter = 0;
    if (isset($_POST['newsletter'])) {
      $newsletter = zen_db_prepare_input($_POST['newsletter']);
    }
  }
  $randPass=randomCode();
  if(isset($_POST['password']) && $_POST['password']){
    $password = zen_db_prepare_input($_POST['password']);
  }
  if(isset($_POST['confirmation']) && $_POST['confirmation']){
    $confirmation = zen_db_prepare_input($_POST['confirmation']);
  }
  if(!$password && !$confirmation){
    $password=$confirmation=$randPass;
  }

  if (DISPLAY_PRIVACY_CONDITIONS == 'true') {
    if (!isset($_POST['privacy_conditions']) || ($_POST['privacy_conditions'] != '1')) {
      $error = true;
      $messageStack->add('checkout_information', ERROR_PRIVACY_STATEMENT_NOT_ACCEPTED, 'error');
      $checkout_errors['information']['privacy_conditions']=ERROR_PRIVACY_STATEMENT_NOT_ACCEPTED;
    }
  }

  if (ACCOUNT_GENDER == 'true') {
    if ( ($gender != 'm') && ($gender != 'f') ) {
      $error = true;
      $messageStack->add('checkout_information', ENTRY_GENDER_ERROR);
      $checkout_errors['information']['gender']=ENTRY_GENDER_ERROR;
    }
  }

  if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_FIRST_NAME_ERROR);
    $checkout_errors['information']['firstname']=ENTRY_FIRST_NAME_ERROR;
  }

  if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_LAST_NAME_ERROR);
    $checkout_errors['information']['lastname']=ENTRY_LAST_NAME_ERROR;
  }

  if (ACCOUNT_DOB == 'true') {
    if (ENTRY_DOB_MIN_LENGTH > 0 or !empty($_POST['dob'])) {
      // Support ISO-8601 style date
      if (preg_match('/^([0-9]{4})(|-|\/)([0-9]{2})\2([0-9]{2})$/', $dob)) {
        $_POST['dob'] = $dob = date(DATE_FORMAT, strtotime($dob));
      }
      if (substr_count($dob,'/') > 2 || checkdate((int)substr(zen_date_raw($dob), 4, 2), (int)substr(zen_date_raw($dob), 6, 2), (int)substr(zen_date_raw($dob), 0, 4)) == false) {
        $error = true;
        $messageStack->add('checkout_information', ENTRY_DATE_OF_BIRTH_ERROR);
        $checkout_errors['information']['dob']=ENTRY_DATE_OF_BIRTH_ERROR;
      }
    }
  }

  if (ACCOUNT_COMPANY == 'true') {
    if ((int)ENTRY_COMPANY_MIN_LENGTH > 0 && strlen($company) < ENTRY_COMPANY_MIN_LENGTH) {
      $error = true;
      $messageStack->add('checkout_information', ENTRY_COMPANY_ERROR);
      $checkout_errors['information']['company']=ENTRY_COMPANY_ERROR;
    }
  }


  if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_EMAIL_ADDRESS_ERROR);
    $checkout_errors['information']['email_address']=ENTRY_EMAIL_ADDRESS_ERROR;
  } elseif (zen_validate_email($email_address) == false) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
    $checkout_errors['information']['email_address']=ENTRY_EMAIL_ADDRESS_CHECK_ERROR;
  } else {
    if(isset($_SESSION['customer_id'])){
        $check_email_query = "select count(*) as total
                            from " . TABLE_CUSTOMERS . "
                            where customers_email_address = '" . zen_db_input($email_address) . "' and customers_id<>'".$_SESSION['customer_id']."'";
    }else{
        $check_email_query = "select count(*) as total
                            from " . TABLE_CUSTOMERS . "
                            where customers_email_address = '" . zen_db_input($email_address) . "'";
    }
    

    $zco_notifier->notify('NOTIFY_CREATE_ACCOUNT_LOOKUP_BY_EMAIL', $email_address, $check_email_query, $send_welcome_email);
    $check_email = $db->Execute($check_email_query);

    if ($check_email->fields['total'] > 0) {
      $error = true;
      $messageStack->add('checkout_information', ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);
      $checkout_errors['information']['email_address']=ENTRY_EMAIL_ADDRESS_ERROR_EXISTS;
    } else {
      $nick_error = false;
      $zco_notifier->notify('NOTIFY_NICK_CHECK_FOR_EXISTING_EMAIL', $email_address, $nick_error, $nick);
      if ($nick_error) {
        $error = true;
      }

    }
  }

  $nick_error = false;
  $nick_length_min = ENTRY_NICK_MIN_LENGTH;
  $zco_notifier->notify('NOTIFY_NICK_CHECK_FOR_MIN_LENGTH', $nick, $nick_error, $nick_length_min);
  if ($nick_error) $error = true;
  $zco_notifier->notify('NOTIFY_NICK_CHECK_FOR_DUPLICATE', $nick, $nick_error);
  if ($nick_error) $error = true;

      // check Zen Cart for duplicate nickname
  if (!$error && zen_not_null($nick)) {
      $sql = "select * from " . TABLE_CUSTOMERS  . "
                           where customers_nick = :nick:";
      $check_nick_query = $db->bindVars($sql, ':nick:', $nick, 'string');
      $check_nick = $db->Execute($check_nick_query);
      if ($check_nick->RecordCount() > 0 ) {
        $error = true;
        $messageStack->add('checkout_information', ENTRY_NICK_DUPLICATE_ERROR);
        $checkout_errors['information']['customers_nick']=ENTRY_NICK_DUPLICATE_ERROR;
      }
  }

  if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_STREET_ADDRESS_ERROR);
    $checkout_errors['information']['street_address']=ENTRY_STREET_ADDRESS_ERROR;
  }

  if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_CITY_ERROR);
    $checkout_errors['information']['city']=ENTRY_CITY_ERROR;
  }

  if (ACCOUNT_STATE == 'true') {
    $check_query = "SELECT count(*) AS total
                    FROM " . TABLE_ZONES . "
                    WHERE zone_country_id = :zoneCountryID";
    $check_query = $db->bindVars($check_query, ':zoneCountryID', $country, 'integer');
    $check = $db->Execute($check_query);
    $entry_state_has_zones = ($check->fields['total'] > 0);
    if ($entry_state_has_zones == true) {
      $zone_query = "SELECT distinct zone_id, zone_name, zone_code
                     FROM " . TABLE_ZONES . "
                     WHERE zone_country_id = :zoneCountryID
                     AND " .
                     ((trim($state) != '' && $zone_id == 0) ? "(upper(zone_name) like ':zoneState%' OR upper(zone_code) like '%:zoneState%') OR " : "") .
                    "zone_id = :zoneID
                     ORDER BY zone_code ASC, zone_name";

      $zone_query = $db->bindVars($zone_query, ':zoneCountryID', $country, 'integer');
      $zone_query = $db->bindVars($zone_query, ':zoneState', strtoupper($state), 'noquotestring');
      $zone_query = $db->bindVars($zone_query, ':zoneID', $zone_id, 'integer');
      $zone = $db->Execute($zone_query);

      //look for an exact match on zone ISO code
      $found_exact_iso_match = ($zone->RecordCount() == 1);
      if ($zone->RecordCount() > 1) {
        while (!$zone->EOF && !$found_exact_iso_match) {
          if (strtoupper($zone->fields['zone_code']) == strtoupper($state) ) {
            $found_exact_iso_match = true;
            continue;
          }
          $zone->MoveNext();
        }
      }

      if ($found_exact_iso_match){
        $zone_id = $zone->fields['zone_id'];
        $zone_name = $zone->fields['zone_name'];
      } else {
        $error = true;
        $error_state_input = true;
        $messageStack->add('checkout_information', ENTRY_STATE_ERROR_SELECT);
        $checkout_errors['information']['state']=ENTRY_STATE_ERROR_SELECT;
      }
    } else {
      if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
        $error = true;
        $error_state_input = true;
        $messageStack->add('checkout_information', ENTRY_STATE_ERROR);
        $checkout_errors['information']['state']=ENTRY_STATE_ERROR;
      }
    }
  }

  if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_POST_CODE_ERROR);
    $checkout_errors['information']['postcode']=ENTRY_POST_CODE_ERROR;
  }

  if ( (is_numeric($country) == false) || ($country < 1) ) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_COUNTRY_ERROR);
    $checkout_errors['information']['country']=ENTRY_COUNTRY_ERROR;
  }

  if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_TELEPHONE_NUMBER_ERROR);
    $checkout_errors['information']['telephone']=ENTRY_TELEPHONE_NUMBER_ERROR;
  }

  $zco_notifier->notify('NOTIFY_CREATE_ACCOUNT_VALIDATION_CHECK', array(), $error, $send_welcome_email);

  if (strlen($password) < ENTRY_PASSWORD_MIN_LENGTH) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_PASSWORD_ERROR);
    $checkout_errors['information']['password']=ENTRY_PASSWORD_ERROR;
  } elseif ($password != $confirmation) {
    $error = true;
    $messageStack->add('checkout_information', ENTRY_PASSWORD_ERROR_NOT_MATCHING);
    $checkout_errors['information']['password']=ENTRY_PASSWORD_ERROR_NOT_MATCHING;
  }
  //verify billing address details
  
  if(isset($_POST['billing_address_different']) && $_POST['billing_address_different']=="true"){
	$billing_address=$_POST['billing_address'];
	
		if (ACCOUNT_GENDER == 'true') {
			if ( ($billing_address['gender'] != 'm') && ($billing_address['gender'] != 'f') ) {
			  $error = true;
			  $messageStack->add('checkout_information', ENTRY_GENDER_ERROR);
			  $checkout_errors['billing_address']['gender']=ENTRY_GENDER_ERROR;
			}
		}
		if (strlen($billing_address['firstname']) < ENTRY_FIRST_NAME_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_information', ENTRY_FIRST_NAME_ERROR);
			$checkout_errors['billing_address']['firstname']=ENTRY_FIRST_NAME_ERROR;
		}
	
		if (strlen($billing_address['lastname']) < ENTRY_LAST_NAME_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_information', ENTRY_LAST_NAME_ERROR);
			$checkout_errors['billing_address']['lastname']=ENTRY_LAST_NAME_ERROR;
		}
		
		if (strlen($billing_address['street_address']) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_information', ENTRY_STREET_ADDRESS_ERROR);
			$checkout_errors['billing_address']['street_address']=ENTRY_STREET_ADDRESS_ERROR;
		}
		
		if (strlen($billing_address['city']) < ENTRY_CITY_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_information', ENTRY_CITY_ERROR);
			$checkout_errors['billing_address']['city']=ENTRY_CITY_ERROR;
		}
		
		if (strlen($billing_address['postcode']) < ENTRY_POSTCODE_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_information', ENTRY_POST_CODE_ERROR);
			$checkout_errors['billing_address']['postcode']=ENTRY_POST_CODE_ERROR;
		}
		
		if ( (is_numeric($billing_address['country_id']) == false) || ($billing_address['country_id'] < 1) ) {
			$error = true;
			$messageStack->add('checkout_information', ENTRY_COUNTRY_ERROR);
			$checkout_errors['billing_address']['country']=ENTRY_COUNTRY_ERROR;
		}
		
		if (ACCOUNT_STATE == 'true') {
			$billing_address['state'] = zen_db_prepare_input($billing_address['state']);
			if (isset($billing_address['zone_id'])) {
			  $billing_address['zone_id'] = zen_db_prepare_input($billing_address['zone_id']);
			} else {
			  $billing_address['zone_id'] = false;
			}
		 }
	
  }