<div id="globalcss">
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>{openzc:define.HEADING_TITLE/}</title>
{openzc:include filename="system/common/css.tpl"/}
</head>
<body>
<div class="container mb-5">
  <div class="block-title subtitle is-4 is-spaced mt-6 px-5 is-hidden-mobile">{openzc:define.HEADING_TITLE/}</div>
  <div class="columns mx-0 ">
    {openzc:include filename="system/account/account_nav.tpl"/}
    <div class="column ">
		<article class="message is-light">
			<div class="message-header"><p>{openzc:define.HEADING_TITLE/}</p></div>
			<div class="message-body px-4 pt-3">
		{openzc:msg name="account"/}
      <div class="columns mx-0 mt-0">
		
        <div class="column is-inline-mobile pl-0">
          <div class="card">
            <div class="card-content">
              <div class="content">
                <h4 class="card-title title is-6 mb-3"><i class="fa fa-address-card"></i> Contact Information</h4>
				<div class="notification is-light mt-3">
                <p class="subtitle is-6">{openzc:account field='customers_firstname'/}&nbsp;&nbsp;{openzc:account field='customers_lastname'/}<br/>
                {openzc:account field='customers_email_address'/}
				</div>
                <p> {openzc:account item="nav" field="edit"} <a class="button is-normal" href="[field:link/]"><i class="fa fa-edit"></i> &nbsp;Edit</a> {/openzc:account} </p>
				
              </div>
            </div>
          </div>
        </div>
        <div class="column is-inline-mobile pr-0">
          <div class="card">
            <div class="card-content">
              <div class="content">
                <h4 class="card-title title is-6 mb-3"><i class="fa fa-rss-square"></i> Notifications Newsletters</h4>
                {openzc:account}
                <p class="subtitle is-6 mt-3">
				{openzc:if $field['customers_newsletter']}
                  <div class="notification is-success is-light ">You are subscribed to "General Subscription".</div>
                  {else}
				  <div class="notification">You aren't subscribed to our newsletter.</div>
                  {/openzc:if} </p>
                {/openzc:account}
                <p>{openzc:account item="nav" field="notice_news"}<a class="button is-normal" href="[field:link/]"><i class="fa fa-edit"></i> &nbsp;Edit</a>{/openzc:account}</p>
              </div>
            </div>
          </div>
        </div>
      </div>
	  <div class="columns is-hidden-desktop">&nbsp;</div>
      <div class="columns mx-0 ">
        <div class="column is-inline-mobile pl-0">
          <div class="card">
            <div class="card-content">
              <div class="content">
                <h4 class="card-title title is-6 mb-3">
					<i class="fas fa-map-marker-alt"></i> Address Book 
                    {openzc:account item="nav" field="address"}
					<a class="subtitle is-7 is-pulled-right pt-1" href="[field:link/]"><i class="fas fa-shipping-fast"></i>&nbsp;Manage Addresses</a>
					{/openzc:account}
				</h4>
                {openzc:account item="address" default="true"}
                {openzc:if $field['status']=="off"}
                You have not set a default billing address.
                {else}
                <p class="subtitle is-6 mt-3">Default Billing Address</p>
                <address>
                [field:address/]
                </address>
                {/openzc:if}
                <p class="mt-2"><a class="button is-normal" href="[field:edit_link/]"><i class="fa fa-edit"></i>&nbsp;Edit Address</a></p>
                {/openzc:account} </div>
            </div>
          </div>
        </div>
        <div class="column is-inline-mobile pr-0">
          <div class="card">
            <div class="card-content">
              <div class="content">
                <h4 class="card-title title is-6 mb-3"><i class="fa fa-list"></i> Order History</h4>
                <p class="subtitle is-6 mt-3">
				  {openzc:if ORDERS_COUNT>0}
				  <div class="notification is-success is-light">See Your Order History.</div>
                  {openzc:account item="nav" field="orders"}
					<a class="button is-normal" href="[field:link/]"><i class="fa fa-search"></i>&nbsp;[field:text/]</a>
				  {/openzc:account}
                  {else}
					<div class="notification">You have not yet made any purchases.</div>
				  {/openzc:if}
				</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
		</article>
  </div>
</div>
	</div>
</body>
{openzc:include filename="system/common/js.tpl"/}
</html>
</div>