<?php
/**
 * Checkout Information Page
 *
 * @package page
 * @copyright Copyright 2003-2018 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: mc12345678 Tue Aug 28 21:18:16 2018 -0400 Modified in v1.5.6 $
 */

// This should be first line of the script:
$zco_notifier->notify('NOTIFY_HEADER_START_CHECKOUT_INFORMATION');
if($_SESSION['checkout_process_style']=="quick"){
    zen_redirect(zen_href_link(FILENAME_CHECKOUT));
}
// redirect the customer to a friendly cookie-must-be-enabled page if cookies are disabled (or the session has not started)
if ($session_started == false) {
  zen_redirect(zen_href_link(FILENAME_COOKIE_USAGE));
}

if ($_SESSION['cart']->count_contents() <= 0) {
    zen_redirect(zen_href_link(FILENAME_SHOPPING_CART));
}
require(DIR_WS_MODULES . zen_get_module_directory('require_languages.php'));
if(!isset($_SESSION['billto']) || !isset($_SESSION['sendto'])){
	$billing_column_sql="SHOW COLUMNS from ".TABLE_ADDRESS_BOOK;
	$billing_address_column=openzcQuery($billing_column_sql);
	$billing_address_column=openzc_table_to_list($billing_address_column,"Field");
	foreach($billing_address_column as $k => $v){
		$k=str_replace("entry_","",$k);
		$billing_address[$k]="";
	}
	$send_address=$billing_address;
}else{
	$send_address_sql="select * from ".TABLE_ADDRESS_BOOK." where address_book_id='".$_SESSION['sendto']."'";
	$send_address=openzcQuery($send_address_sql);
	$send_address=openzc_table_to_list($send_address)[0];
	$bill_address_sql="select * from ".TABLE_ADDRESS_BOOK." where address_book_id='".$_SESSION['billto']."'";
	$bill_address=openzcQuery($bill_address_sql);
	$bill_address=openzc_table_to_list($bill_address)[0];
	foreach($bill_address as $k => $v){
		$k=str_replace("entry_","",$k);
		$billing_address[$k]=$v;
	}
	$billing_address_data=$billing_address;
}

if (isPost() && isset($_POST['action']) && ($_POST['action'] == 'process')) {
	if (!isset($_SESSION['customer_id'])) {
		
		require(DIR_WS_MODULES . zen_get_module_directory('checkout_create_account.php'));
		$information_errors=$checkout_errors['information'];
		if(!isset($_SESSION['comments'])){
			$_SESSION['comments']="";
		}
	}else{
	  //checkout information form verify start--------------
	  /*** Set some defaults*/
	  $process = false;
	  $zone_name = '';
	  $entry_state_has_zones = '';
	  $error_state_input = false;
	  $state = '';
	  $zone_id = 0;
	  $error = false;
	  $email_format = (ACCOUNT_EMAIL_PREFERENCE == '1' ? 'HTML' : 'TEXT');
	  $newsletter = (ACCOUNT_NEWSLETTER_STATUS == '1' || ACCOUNT_NEWSLETTER_STATUS == '0' ? false : true);
	  $extra_welcome_text = '';
	  $send_welcome_email = true;
	  
	  require(DIR_WS_MODULES . zen_get_module_directory('checkout_information_verify.php'));
	  
	  //checkout information form verify end--------------
	  if ($error == false) {
		  $customer_sql="select * from ".TABLE_CUSTOMERS." where customers_id='".$_SESSION['customer_id']."'";
		  $customer=openzcQuery($customer_sql);
		  $customer=openzc_table_to_list($customer)[0];
		  
		  //检查更新内容
		  $customer_update=array();
		  foreach($customer as $k => $v){
			$key=str_replace("customers_","",$k);
			if(isset($_POST[$key]) && $_POST[$key]!=$v){$customer_update[$k]=$_POST[$key];}
		  }
		  
		  
		  $send_address_update=array();
		  foreach($send_address as $k => $v){
			$key=str_replace("entry_","",$k);
			if(strstr($key,"country")){$key="zone_".$key;}
			if(isset($_POST[$key]) && $_POST[$key]!=$v){$send_address_update[$k]=$_POST[$key];}
		  }
		 
		  if($_SESSION['sendto']!=$_SESSION['billto']){
			$bill_address_update=array();
			foreach($billing_address as $k => $v){
			  if(!strstr($k,"_id") || strstr($k,"country") || strstr($k,"zone_id")){
				
				$key="entry_".$k;
				
			  }
			  if(isset($billing_address_data[$k]) && $v!=$billing_address_data[$k]){$bill_address_update[$key]=$_POST["billing_address"][$k];}
			}
		  }
		 
		  if($_SESSION['sendto']==$_SESSION['billto'] && isset($_POST['billing_address_different']) && $_POST['billing_address_different']=='true'){
		  	$billing_address=$_POST['billing_address'];
			
				$sql_data_array = array(array('fieldName'=>'customers_id', 'value'=>$_SESSION['customer_id'], 'type'=>'integer'),
									array('fieldName'=>'entry_firstname', 'value'=>$billing_address['firstname'], 'type'=>'stringIgnoreNull'),
									array('fieldName'=>'entry_lastname', 'value'=>$billing_address['lastname'], 'type'=>'stringIgnoreNull'),
									array('fieldName'=>'entry_street_address', 'value'=>$billing_address['street_address'], 'type'=>'stringIgnoreNull'),
									array('fieldName'=>'entry_postcode', 'value'=>$billing_address['postcode'], 'type'=>'stringIgnoreNull'),
									array('fieldName'=>'entry_city', 'value'=>$billing_address['city'], 'type'=>'stringIgnoreNull'),
									array('fieldName'=>'entry_country_id', 'value'=>$billing_address['zone_country_id'], 'type'=>'integer'),
				);
		
				if (ACCOUNT_GENDER == 'true') $sql_data_array[] = array('fieldName'=>'entry_gender', 'value'=>$billing_address['gender'], 'type'=>'stringIgnoreNull');
				if (ACCOUNT_COMPANY == 'true') $sql_data_array[] = array('fieldName'=>'entry_company', 'value'=>$billing_address['company'], 'type'=>'stringIgnoreNull');
				if (ACCOUNT_SUBURB == 'true') $sql_data_array[] = array('fieldName'=>'entry_suburb', 'value'=>$billing_address['suburb'], 'type'=>'stringIgnoreNull');
		
				if (ACCOUNT_STATE == 'true') {
				  if ($billing_address['zone_id'] > 0) {
					$sql_data_array[] = array('fieldName'=>'entry_zone_id', 'value'=>$billing_address['zone_id'], 'type'=>'integer');
					$sql_data_array[] = array('fieldName'=>'entry_state', 'value'=>'', 'type'=>'stringIgnoreNull');
				  } else {
					$sql_data_array[] = array('fieldName'=>'entry_zone_id', 'value'=>0, 'type'=>'integer');
					$sql_data_array[] = array('fieldName'=>'entry_state', 'value'=>$billing_address['state'], 'type'=>'stringIgnoreNull');
				  }
				}
		
				$db->perform(TABLE_ADDRESS_BOOK, $sql_data_array);
		
				$billing_address_id = $db->Insert_ID();
				$_SESSION['billto'] = $billing_address_id;
		  
		  }else{
		  	$_SESSION['billto']=$_SESSION['sendto'];
		  }
		  if(sizeof($customer_update)>0){
			  $sql_data_array=array();
			  foreach($customer_update as $k => $v){
				if (ACCOUNT_GENDER == 'true' && $k=="customers_gender" && !$v){
					$messageStack->add('checkout', ENTRY_GENDER_ERROR);
					$checkout_errors['information']['gender']=ENTRY_GENDER_ERROR;
					continue;
				}
				$sql_data_array[]=['fieldName'=>$k, 'value'=>$v, 'type'=>'stringIgnoreNull'];
			  }
			  $where_clause = "customers_id = :customersID";
			  $where_clause = $db->bindVars($where_clause, ':customersID', $_SESSION['customer_id'], 'integer');
			  $db->perform(TABLE_CUSTOMERS, $sql_data_array, 'update', $where_clause);
		  }
		  if(sizeof($send_address_update)>0){
			  $sql_data_array=array();
			  foreach($send_address_update as $k => $v){
				$sql_data_array[]=['fieldName'=>$k, 'value'=>$v, 'type'=>'stringIgnoreNull'];
			  }
			  $where_clause = "address_book_id = :addressID";
			  $where_clause = $db->bindVars($where_clause, ':addressID', $_SESSION['sendto'], 'integer');
			  $db->perform(TABLE_ADDRESS_BOOK, $sql_data_array, 'update', $where_clause);
		  }
		  if(sizeof($bill_address_update)>0){
			  $sql_data_array=array();
			  foreach($bill_address_update as $k => $v){
				$sql_data_array[]=['fieldName'=>$k, 'value'=>$v, 'type'=>'stringIgnoreNull'];
			  }
			  
			  $where_clause = "address_book_id = :addressID";
			  $where_clause = $db->bindVars($where_clause, ':addressID', $_SESSION['billto'], 'integer');
			  $db->perform(TABLE_ADDRESS_BOOK, $sql_data_array, 'update', $where_clause);
		  }
		  zen_redirect(zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
	  }else{
	  	$information_errors=$checkout_errors['information'];
	  }
}

}
