﻿<!DOCTYPE html>
<html lang="en-US">
<head>
<!-- Meta============================================= -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, intial-scale=1, max-scale=1">
<meta name="author" content="OpenzcTPL.">
<title>{openzc:define.META_TAG_TITLE/}</title>
<meta name="keywords" content="{openzc:define.META_TAG_KEYWORDS/}" />
<meta name="description" content="{openzc:define.META_TAG_DESCRIPTION/}" />
<!-- Stylesheets============================================= -->
{openzc:include filename="common/css.tpl"/}
<!-- Favicon============================================= -->
{openzc:include filename="common/favicon.tpl"/}
</head>
<body>

<!-- Document Full Container
	============================================= -->
<div id="full-container"> 
  
  <!-- Header============================================= -->
  {openzc:include filename="common/header.tpl"/}
  <!-- #header end --> 
  
  <!-- Content
		============================================= -->
  <section id="content">
    <div id="content-wrap"> 
      
      <!-- Page Title
				============================================= -->
      <div id="page-title">
        <div id="page-title-wrap">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <ul class="breadcrumb">
                  {openzc:field.position/}
                </ul>
                
              </div>
              <!-- .col-md-12 end --> 
            </div>
            <!-- .row end --> 
          </div>
          <!-- .container end --> 
          
        </div>
        <!-- #page-title-wrap end --> 
        
      </div>
      <!-- #page-title end --> 

      <!-- === Content Main =========== -->
      <div id="content-main" class="section-flat page-single page-shop-cart">
        <div class="section-content">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <div class="page-single-content">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="content" >
						
                        <div class="block-content">
						  {openzc:if $cartCount>0}
							<div id="globalcss">{openzc:msg name='shopping_cart'/}</div>
                          <h5 class="block-title">{openzc:define.HEADING_TITLE/} <span class="cartCount1">( {openzc:var name='$cartCount' ajax="cartCount1" autodiv=".cartCount1"/} )</span></h5>
                          <div class="row" id="cartlist">
							{openzc:ajax filename="cartlist" autodiv="#cartlist"}
                            <div class="col-md-12">
                              <div id="table-shop-cart">
                                <table>
                                  <thead>
                                    <tr>
                                      <th>&nbsp;</th>
                                      <th>Product Image</th>
                                      <th>Product Name</th>
                                      <th>Price</th>
                                      <th>Quantity</th>
                                      <th>Price</th>
                                    </tr>
                                  </thead>
                                  <tbody>
									{openzc:cart imgsizer="62,62"}
                                    <tr>
                                      <td><a class="item-delete openzc-btn" data-action="delCart" data-id="[field:id/]" data-reload-group="cartlist" href="javascript:;"><i class="fa fa-trash-alt"></i></a></td>
                                      <td><a href="[field:products_link/]"><img src="[field:products_image/]" alt=""></a></td>
                                      <td><ul class="cart-item">
                                          
                                          <li>
                                            <h5><a href="[field:products_link/]">[field:products_name/]</a>[field:flagStockCheck/]</h5>
                                          </li>
                                          <li>
											{openzc:loopson item="attr"}
                                            <div class="item-color">[field:products_options_name/] : <span>[field:products_options_values_name/]</span></div>
											{/openzc:loopson}
                                          </li>
                                        </ul>
                                        <!-- .cart-item end --></td>
                                      <td><h6>[field:products_price/]</h6></td>
                                      <td><form class="counter-add-item">
                                          <a class="decrease-btn openzc-btn" data-action="cutOne" data-id="[field:id/]" data-reload-group="cartlist" href="javascript:;">-</a>
                                          <input type="text" value="[field:products_qty/]">
                                          <a class="increase-btn openzc-btn" data-action="addOne" data-id="[field:id/]" data-reload-group="cartlist" href="javascript:;">+</a>
                                        </form>
                                        <!-- .counter-add-item end --></td>
                                      <td><h6>[field:products_price_total/]</h6></td>
                                    </tr>
									{/openzc:cart}
                                  </tbody>
                                </table>
                              </div>
                              <!-- #table-shop-cart end -->
                              <div class="table-btns">
								  <a class="btn medium colorful hover-grey" href="javascript:;"><i class="fa fa-angle-double-down"></i>&nbsp;&nbsp;Continue Shopping</a>
								  <a class="btn medium dark hover-grey openzc-btn" href="javascript:;" data-action="clearCart" data-reload-group="cartlist">Clear Cart</a>
							  </div>
                              <!-- .table-btns end -->
                              
                              <div id="table-checkout">
                                <table>
                                  <tbody>
									  {openzc:modules item="order_total"}
                                    <tr>
                                      <td colspan="3" style="text-align:right">[field:title/] <span>[field:text/]</span></td>
                                    </tr>
									  {/openzc:modules}
                                   <tr></tr>
                                  </tbody>
                                </table>
                              </div>
								<div class="table-btns"  style="text-align:right;display:block">
									 <a class="btn medium colorful hover-dark" href="{openzc:link name='FILENAME_CHECKOUT'/}"><i class="fa fa-cart-arrow-down"></i>Checkout</a>
								</div>
                              <!-- #table-checkout end --> 
                            </div>
							{/openzc:ajax}
                            <!-- .col-md-12 end --> 
                          </div>
                          <!-- .row end -->
						  {else}
						  <p>Shopping cart is empty!</p>
						  {/openzc:if}
                        </div>
						
                        <!-- .block-content end --> 
                      </div>
                      <!-- .content end --> 
                      
                    </div>
                    <!-- .col-md-12 end --> 
                  </div>
                  <!-- .row end --> 
                  
                </div>
                <!-- .page-single-content end --> 
                
              </div>
              <!-- .col-md-12 end --> 
            </div>
            <!-- .row end --> 
          </div>
          <!-- .container end --> 
          
        </div>
        <!-- .section-content end --> 
        
      </div>
      <!-- .section-flat end --> 
      
    </div>
    <!-- #content-wrap --> 
    
  </section>
  <!-- #content end --> 
  
  <!-- Footer
		============================================= -->
  <footer id="footer">
    {openzc:include filename="common/newsletters.tpl"/}
    {openzc:include filename="common/footer.tpl"/}
  </footer>
  <!-- #footer end -->
  
  <div class="side-full-categories">
    <div class="mobile-full-categories">
      <h5>All Categories</h5>
      <ul class="mobile-menu-categories">
      </ul>
      <!-- .mobile-menu-categories end --> 
    </div>
    <!-- .mobile-full-categories end --> 
  </div>
  <!-- .side-full-categories end -->
  
  <div class="box-notification"> <i class="fa fa-cart-arrow-down"></i>
    <div class="box-content"> <span>Added to Cart</span>
      <h5>Elitebook 2019</h5>
      <a class="btn x-small grey hover-colorful" href="javascript:;">Shop Cart</a> </div>
    <!-- .box-content end --> 
    <a class="close" href="javascript:;">×</a> </div>
  <!-- .box-notification end --> 
  
</div>
<!-- #full-container end --> 

<a class="scroll-top-icon scroll-top" href="javascript:;"><i class="fa fa-angle-up"></i></a> 

<!-- External JavaScripts============================================= --> 
{openzc:include filename="common/script.tpl"/}
</body>
</html>
