<div id="globalcss">
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>{openzc:define.HEADING_TITLE/}</title>
{openzc:include filename="system/account/css.tpl"/}
</head>
<body>
<div class="container mb-5">
  <div class="block-title subtitle is-4 is-spaced mt-6 px-5 is-hidden-mobile">{openzc:define.HEADING_TITLE/}</div>
  <div class="columns mx-0">
    {openzc:include filename="system/account/account_nav.tpl"/}
    <div class="column ">
      <article class="message is-light">
        <div class="message-header">
          <p>{openzc:define.HEADING_TITLE/}</p>
        </div>
        <div class="message-body px-3">
          <div class="table-container is-hidden-mobile">
			{openzc:if ORDERS_COUNT>0}
            <table class="table is-bordered is-striped is-narrow is-hoverable is-fullwidth">
              <thead>
                <tr>
                  <th class="py-2">{openzc:define.TEXT_ORDER_NUMBER/} #</th>
                  <th class="py-2">{openzc:define.TEXT_ORDER_DATE/}</th>
                  <th class="py-2">{openzc:define.TEXT_ORDER_COST/}</th>
                  <th class="py-2">{openzc:define.TEXT_ORDER_STATUS/}</th>
                  <th class="py-2"></th>
                </tr>
              </thead>
              <tbody>
              {openzc:account item="orders"}
              <tr>
                <th class="py-2 pt-4 subtitle is-6">[field:orders_id/]</th>
                <td class="py-2 pt-4 subtitle is-6">[field:date_purchased/]</td>
                <td class="py-2 pt-4 subtitle is-6">[field:order_total/]</td>
                <td class="py-2 pt-4 subtitle is-6">[field:orders_status_name/]</td>
                <td class="py-2 subtitle is-6"><a class="button is-info is-light subtitle is-7" href="[field:order_link/]"><i class="fas fa-search-plus"></i>&nbsp;&nbsp;View</a></td>
              </tr>
              {/openzc:account}
              </tbody>
            </table>
            {else}
            <div class="notification is-warning is-light"> <i class="fa fa-exclamation-triangle"></i> You have placed no orders. </div>
            {/openzc:if}
		</div>
		<div class="is-hidden-desktop">
			{openzc:account item="orders" field="result_page"/}
			{openzc:account item="orders"}
			<div class="box">
				<p>
				<span class="title is-6"><i class="fa fa-list-alt"></i> {openzc:define.TEXT_ORDER_NUMBER/}&nbsp;#<span class="title is-6">[field:orders_id/]&nbsp;&nbsp;<i class="fa fa-angle-right"></i></span></span>
				</p>
				<p class="mt-2">
				<span class="subtitle is-7">{openzc:define.TEXT_ORDER_DATE/}&nbsp;[field:date_purchased/]</span>
				</p>
				<p>
				<span class="subtitle is-7">{openzc:define.TEXT_ORDER_COST/}&nbsp;[field:order_total/]</span>
				</p>
				<p>
				<span class="subtitle is-7">{openzc:define.TEXT_ORDER_STATUS/}&nbsp;[field:orders_status_name/]</span>
				</p>
				<p><a class="button mt-3 is-flex is-outlined" href="[field:order_link/]"><i class="fas fa-search-plus"></i>&nbsp;&nbsp;view info</a></p>
			</div>
			{/openzc:account}
		</div>
      </div>
      </article>
    </div>
  </div>
</div>
</body>
{openzc:include filename="system/account/js.tpl"/}
</html>
</div>