<div id="globalcss">
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>{openzc:define.HEADING_TITLE/}</title>
{openzc:include filename="system/common/css.tpl"/}
</head>
<body>
<div class="container mb-5">
  <div class="block-title subtitle is-4 is-spaced mt-6 px-5 is-hidden-mobile">{openzc:define.HEADING_TITLE/}</div>
  <div class="columns mx-0">
    {openzc:include filename="system/account/account_nav.tpl"/}
    <div class="column ">
		
      <div class="card">
        <div class="card-body p-5 ">
			<span class="title is-3 is-flex">#{openzc:account item="orders" field="orders_id"/}</span>
			<span class="title is-6 is-flex">{openzc:define.HEADING_ORDER_DATE/}&nbsp;&nbsp;{openzc:account item="orders" field="date_purchased"/}</span>
			<span class="title is-4 is-flex has-text-grey mt-3">{openzc:define.HEADING_TITLE/}{openzc:define.ORDER_HEADING_DIVIDER/}#{openzc:account item="orders" field="orders_id"/}</span>
			<div class="table-container is-hidden-mobile"> 
			<table class="table is-fullwidth ">
				  <thead>
					<tr>
					  <th>{openzc:define.HEADING_QUANTITY/}</th>
                      <th>{openzc:define.HEADING_PRODUCTS/}</th>
                      {openzc:if sizeof($order->info['tax_groups'])>1}
                      <th>{openzc:define.HEADING_TAX/}</th>
                      {/openzc:if}
                      <th>{openzc:define.HEADING_TOTAL/}</th>
					</tr>
				  </thead>
				<tbody>
					{openzc:account item="orders" field="products"}
                          <tr>
                            <td class="subtitle is-6">[field:qty/] {openzc:define.QUANTITY_SUFFIX/}</td>
                            <td class="subtitle is-6"><span class="h6">[field:name/]</span>
                              <ul class="list-group list-group-flush">
                                {openzc:loopson attr="true"}
                                <li class="list-group-item" style="border:none;"> [field:option/] : [field:value/] </li>
                                {/openzc:loopson}
                              </ul></td>
                            {openzc:if sizeof($order->info['tax_groups'])>1}
                            <td class="subtitle is-6">[field:tax/]</td>
                            {/openzc:if}
                            <td class="subtitle is-6">[field:final_price/]</td>
                         
                          </tr>
                          {/openzc:account}
                          
                          {openzc:account item="orders" field="totals"}
                          <tr class="">
							{openzc:if sizeof($order->info['tax_groups'])>1}
                            <th colspan="4" align="right">[field:title/] [field:text/]</th>
							{else}
							<th colspan="3" align="right">[field:title/] [field:text/]</th>
							{/openzc:if}
                          </tr>
                          {/openzc:account}
				</tbody>
			</table>
			</div>
			
			<div class="box is-hidden-desktop">
				{openzc:account item="orders" field="products"}
				<p class="mt-4">
						<span class="title is-6"><i class="fas fa-dolly"></i> {openzc:define.HEADING_PRODUCTS/} :&nbsp;<span class="title is-7">[field:name/]</span></span>
					</p>
					 <p>
						 {openzc:loopson attr="true"}
						<span class="subtitle is-7 ">[field:option/] : [field:value/]</span><br/>
						 {/openzc:loopson}
					</p>
					<p><span class="subtitle is-7">{openzc:define.HEADING_QUANTITY/} &nbsp;[field:qty/]{openzc:define.QUANTITY_SUFFIX/}</span></p>
					{openzc:if sizeof($order->info['tax_groups'])>1}
				    <p><span class="subtitle is-7">{openzc:define.HEADING_TAX/} :&nbsp;[field:tax/]</span></p>
				    {/openzc:if}
					<p><span class="subtitle is-7"><b>{openzc:define.HEADING_TOTAL/} : &nbsp;[field:final_price/]</b></span></p>
				{/openzc:account}
				<div class="mt-4 clumns">
					{openzc:account item="orders" field="totals"}
						<p class="is-clearfix"><span class="title is-6 is-pulled-right mt-3">[field:title/] &nbsp;[field:text/]</span></p>
					{/openzc:account}
				</div>
			</div>
			
			<!--{openzc:define.HEADING_ORDER_HISTORY/}-->
			<span class="title is-4 is-flex">{openzc:define.HEADING_ORDER_HISTORY/}</span>
			<div class="clumns">
				<div class="table-container is-hidden-mobile">
                        <table class="table is-fullwidth">
                          <thead>
                            <tr>
                              <th>{openzc:define.TABLE_HEADING_STATUS_DATE/}</th>
                              <th>{openzc:define.TABLE_HEADING_STATUS_ORDER_STATUS/}</th>
                              <th>{openzc:define.TABLE_HEADING_STATUS_COMMENTS/}</th>
                            </tr>
                          </thead>
                          <tbody>
                          
                          {openzc:account item="orders" field="status_history"}
                          <tr>
                            <td class="subtitle is-6">[field:date_added/]</td>
                            <td class="subtitle is-6">[field:orders_status_name/]</td>
                            <td class="subtitle is-6">[field:comments/]</td>
                          </tr>
                          {/openzc:account}
                            </tbody>
                          
                        </table>
                 </div>
				{openzc:account item="orders" field="status_history"}
				 <div class="box is-hidden-desktop">
					 <p>
						<span class="title is-6"><i class="fas fa-history"></i> {openzc:define.TABLE_HEADING_STATUS_DATE/} :&nbsp;<span class="title is-7">[field:date_added/]</span></span>
					</p>
					 <p class="mt-2">
						<span class="subtitle is-7">{openzc:define.TABLE_HEADING_STATUS_ORDER_STATUS/} :&nbsp;[field:orders_status_name/]</span>
					</p>
					 <p >
						<span class="subtitle is-7">{openzc:define.TABLE_HEADING_STATUS_COMMENTS/} :&nbsp;</span>
						<span class="subtitle is-7">[field:comments/]</span>
					</p>
				 </div>
				{/openzc:account}
			</div>
			<div class="columns mt-3">
				<div class="column is-half">
					<span class="title is-4 is-flex">{openzc:define.HEADING_DELIVERY_ADDRESS/}</span>
					<p class="subtitle is-6 pt-2">{openzc:account item="orders" field="delivery"/}</p>
				</div>
				<div class="column is-half">
					<span class="title is-4 is-flex">{openzc:define.HEADING_BILLING_ADDRESS/}</span>
					<p class="subtitle is-6 pt-2">{openzc:account item="orders" field="billing"/}</p>
				</div>
			</div>
			<div class="columns mt-3">
				<div class="column is-half">
					<span class="title is-4 is-flex">{openzc:define.HEADING_SHIPPING_METHOD/}</span>
					<p class="subtitle is-6 pt-2">{openzc:account item="orders" field="shipping_method"/}</p>
				</div>
				<div class="column is-half">
					<span class="title is-4 is-flex">{openzc:define.HEADING_PAYMENT_METHOD/}</span>
					<p class="subtitle is-6 pt-2">{openzc:account item="orders" field="payment_method"/}</p>
				</div>
			</div>
			<div class="columns level mt-5">
				<p class="level-right"><a class="button" href="{openzc:link name='FILENAME_ACCOUNT'/}"><i class="fas fa-reply"></i>&nbsp;&nbsp;{openzc:define.BUTTON_BACK_ALT/}</a></p>
			</div>
		</div>
      </div>
    </div>
  </div>
</div>
</body>
{openzc:include filename="system/common/js.tpl"/}
</html>
</div>